package com.biz.crm.tpm.business.audit.fee.local.consumer;

import com.alibaba.fastjson.JSON;
import com.biz.crm.mn.common.rocketmq.service.AbstractRocketMqConsumer;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.audit.fee.sdk.constants.AuditFeeConstants;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeMatchDto;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckVoService;
import lombok.extern.slf4j.Slf4j;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 商超费用匹配细案
 * @author WangJJ
 */
@Slf4j
@Component
@RocketMQMessageListener(topic = AuditFeeConstants.AUDIT_FEE_CHECK_MATCH_JOB_TOPIC + "${rocketmq.environment}",
        /**
         * tag
         * 可用 || 监听多个tag： "tag1 || tag2 || tag3"
         * 请把tag定义在 RocketMQConstant.CRM_MQ_TAG 内统一维护
        */
        selectorExpression = AuditFeeConstants.AUDIT_FEE_CHECK_MATCH_JOB_TAG,
        /**
         * 相同分组下 consumer 可自动负载均衡
        */
        consumerGroup = AuditFeeConstants.AUDIT_FEE_CHECK_MATCH_JOB_TAG + "${rocketmq.environment}",
        /**
         * 默认集群消费
         * 可以设置 ConsumeMode.ORDERLY 使用广播消费
         * 也可使用集群模式模拟广播模式：
         * 启动多个不同 consumerGroup 的consumer实例
        */
        consumeMode = ConsumeMode.CONCURRENTLY,
        /**
         * 集群消费or广播消费;默认是集群消费
        */
        messageModel = MessageModel.CLUSTERING)
public class AuditFeeCheckMatchJobConsumer extends AbstractRocketMqConsumer {

    @Autowired(required = false)
    private AuditFeeCheckVoService auditFeeCheckVoService;

    @Override
    protected Object handleMessage(MqMessageVo message) {
        try {
            String msgBody = message.getMsgBody();
            log.info("---------------------------------------------【商超费用匹配细案 matchFee】消息开始执行--------------------------------------------------" +
                    "----------------------------------------------" + msgBody + "-----------------------------------");
            AuditFeeMatchDto matchDto = JSON.parseObject(msgBody, AuditFeeMatchDto.class);
            this.auditFeeCheckVoService.matchFee(matchDto);
            log.info("---------------------------------------------【商超费用匹配细案 matchFee】消息执行结束--------------------------------------------------" +
                    "----------------------------------------------" + msgBody + "-----------------------------------");
        } catch (Exception e) {
            log.error("", e);
        }
        return "消费成功";
    }
}