package com.biz.crm.tpm.business.audit.fee.local.consumer;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.constant.DictConstant;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgAllParentVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.rocketmq.service.AbstractRocketMqConsumer;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.audit.fee.local.util.AuditFeeDiffTrackPassDetailedForecastBuilder;
import com.biz.crm.tpm.business.audit.fee.local.util.AuditFeeDiffTrackPassDetailedForecastUtil;
import com.biz.crm.tpm.business.audit.fee.sdk.constants.AuditFeeDiffTrackConstants;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.track.AuditFeeDiffTrackDetailDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.track.AuditFeeDiffTrackForecastDto;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.AuditFeeDiffTrackPassMqTagEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.service.track.AuditFeeDiffTrackVoService;
import com.biz.crm.tpm.business.detailed.forecast.local.util.ActivityDetailPlanPassDetailedForecastUtil;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastDto;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

/**
 * 差异费用追踪监听
 * @author wanghaojia
 * @date 2023/1/16 19:59
 */
@Slf4j
@Component
@RocketMQMessageListener(topic = AuditFeeDiffTrackConstants.TPM_AUDIT_FEE_DIFF_TRACK_PROCESS_PASS_TOPIC + "${rocketmq.environment}",
        /**
         * tag
         * 可用 || 监听多个tag： "tag1 || tag2 || tag3"
         * 请把tag  定义在 *** 内 需要统一维护
        */
        selectorExpression = AuditFeeDiffTrackConstants.PASS_DETAILED_FORECAST,
        /**
         * 相同分组下 consumer 可自动负载均衡
         * 请把consumerGroup  定义在 *** 内 需要统一维护
        */
        consumerGroup = AuditFeeDiffTrackConstants.PASS_DETAILED_FORECAST + "${rocketmq.environment}",
        /**
         * 默认集群消费MqConstant
         * 可以设置 ConsumeMode.ORDERLY 使用广播消费
         * 也可使用集群模式模拟广播模式：
         * 启动多个不同 consumerGroup 的consumer实例
        */
        consumeMode = ConsumeMode.CONCURRENTLY,
        /**
         * 集群消费or广播消费;默认是集群消费
        */
        messageModel = MessageModel.CLUSTERING)
public class AuditFeeDiffTrackPassDetailedForecastConsumer extends AbstractRocketMqConsumer {

    @Autowired(required = false)
    private AuditFeeDiffTrackVoService auditFeeDiffTrackVoService;

    @Autowired(required = false)
    private ActivityDetailPlanPassDetailedForecastUtil activityDetailPlanPassDetailedForecastUtil;

    @Autowired(required = false)
    private AuditFeeDiffTrackPassDetailedForecastUtil auditFeeDiffTrackPassDetailedForecastUtil;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Autowired(required = false)
    private CustomerVoService customerVoService;

    @Autowired(required = false)
    private SalesOrgVoService salesOrgVoService;

    @Autowired(required = false)
    private DictToolkitService dictToolkitService;

    @Override
    protected Object handleMessage(MqMessageVo message) {
        log.info("差异追踪审批通过推送细案预测表 order mq message received  : {}", message);
        if (Objects.isNull(message)
                || StringUtils.isEmpty(message.getMsgBody())) {
            return "消息为空!";
        }
        try {
            List<String> businessNoList = JSON.parseArray(message.getMsgBody(), String.class);
            List<AuditFeeDiffTrackForecastDto> dtoList = auditFeeDiffTrackVoService.buildAuditFeeDiffTrackPlanParams(businessNoList);

            UserIdentity loginUser = loginUserService.getLoginUser();
            if (!CollectionUtils.isEmpty(dtoList)) {
                Map<String, String> regionMap = dictToolkitService.findMapByDictTypeCode(DictConstant.MDM_CUSTOMIZE_ORG);
                dtoList.forEach(trackDetailPlanDto -> {
                    if (Objects.isNull(trackDetailPlanDto) || CollectionUtil.isEmpty(trackDetailPlanDto.getItemList())) {
                        return;
                    }
                    List<String> cusCodes = trackDetailPlanDto.getItemList().stream().filter(e -> StringUtils.isNotEmpty(e.getCustomerCode())).map(AuditFeeDiffTrackDetailDto::getCustomerCode).distinct().collect(Collectors.toList());
                    Map<String, CustomerVo> customerVoMap = new HashMap<>();
                    if (!CollectionUtils.isEmpty(cusCodes)) {
                        //指标有的表里面没有客户拼接后编码，强校验了erp编码
                        List<CustomerVo> customerVos = customerVoService.findBaseByCustomerCodes(cusCodes);
                        if (!CollectionUtils.isEmpty(customerVos)) {
                            customerVoMap.putAll(
                                    customerVos.stream()
                                            .filter(e -> StringUtils.isNotEmpty(e.getErpCode()))
                                            .collect(Collectors.toMap(CustomerVo::getCustomerCode, v -> v)));
                        }
                    }

                    List<String> salesOrgCodes = trackDetailPlanDto.getItemList().stream().filter(e -> StringUtils.isNotEmpty(e.getActivityOrgCode())).map(AuditFeeDiffTrackDetailDto::getActivityOrgCode).distinct().collect(Collectors.toList());
                    Map<String, SalesOrgAllParentVo> salesOrgVoMap = new HashMap<>();
                    if (!CollectionUtils.isEmpty(salesOrgCodes)) {
                        List<SalesOrgAllParentVo> list = salesOrgVoService.findSalesOrgIncludeAllParentByCodes(salesOrgCodes);
                        salesOrgVoMap.putAll(list.stream().collect(Collectors.toMap(SalesOrgAllParentVo::getCurrSalesOrgCode, v -> v, (v1, v2) -> v2)));
                    }

                    trackDetailPlanDto.getItemList().forEach(item -> {
                        SalesOrgAllParentVo salesOrgAllParentVo = null;
                        if (StringUtils.isNotEmpty(item.getActivityOrgCode())) {
                            salesOrgAllParentVo = salesOrgVoMap.get(item.getActivityOrgCode());
                        }
                        CustomerVo customerVo = null;
                        if (StringUtils.isNotEmpty(item.getCustomerCode())) {
                            customerVo = customerVoMap.get(item.getCustomerCode());
                        }
                        DetailedForecastDto detailedForecastDto = AuditFeeDiffTrackPassDetailedForecastBuilder.buildUnit1Dto(trackDetailPlanDto, item, regionMap, customerVo, salesOrgAllParentVo);
                        log.info("细案编码[{}]明细编码[{}]差异追踪细案预测使用细案", JSON.toJSONString(item));
                        log.info("细案编码[{}]明细编码[{}]差异追踪细案预测预测数据init", JSON.toJSONString(detailedForecastDto));
                        if (StringUtils.equals(trackDetailPlanDto.getBusinessUnitCode(), BusinessUnitEnum.HEADQUARTERS.getCode())) {
                            //主体
                            try {
                                auditFeeDiffTrackPassDetailedForecastUtil.buildUnit1Param(trackDetailPlanDto, detailedForecastDto, item, loginUser);
                            } catch (Exception e) {
                                log.error("细案编码[{}]明细编码[{}]细案预测生成失败：{}", detailedForecastDto.getDetailedCaseCode(), detailedForecastDto.getActivityDetailItemCode(), e.getMessage());
                                e.printStackTrace();
                            }
                        } else if (StringUtils.equals(trackDetailPlanDto.getBusinessUnitCode(), BusinessUnitEnum.VERTICAL.getCode())) {
                            //垂直
                            try {
                                auditFeeDiffTrackPassDetailedForecastUtil.buildUnit3Param(detailedForecastDto, item, loginUser);
                            } catch (Exception e) {
                                log.error("细案编码[{}]明细编码[{}]细案预测生成失败：{}", detailedForecastDto.getDetailedCaseCode(), detailedForecastDto.getActivityDetailItemCode(), e.getMessage());
                                e.printStackTrace();
                            }
                        }
                    });
                });
            }

        } catch (Exception e) {
            log.error(AuditFeeDiffTrackPassMqTagEnum.PASS_DETAILED_FORECAST.getName() + "处理失败" + e.getMessage(), e);
            return "消费失败." + e.getMessage();
        }
        return "消费成功.";
    }
}
