package com.biz.crm.tpm.business.audit.fee.local.consumer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.mn.common.rocketmq.service.AbstractRocketMqConsumer;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.YesOrNoEnum;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormVo;
import com.biz.crm.tpm.business.audit.fee.local.service.perdiction.AuditFeePredictionService;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.prediction.AuditFeePredictionDto;
import com.biz.crm.tpm.business.audit.sdk.enumeration.DataSourceEnum;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.constant.SubComActivityDetailPlanConstant;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.constant.SubComActivityDetailPlanPassMqTagConstant;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.enums.SubComActivityDetailPlanPassMqTagEnum;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author zy
 * @date 2023/09/24
 */
@Slf4j
@Component
@RocketMQMessageListener(topic = SubComActivityDetailPlanConstant.TPM_SUB_COM_ACTIVITY_DETAIL_PLAN_PROCESS_PASS_TOPIC + "${rocketmq.environment}",
        /**
         * tag
         * 可用 || 监听多个tag： "tag1 || tag2 || tag3"
         * 请把tag  定义在 *** 内 需要统一维护
        */
        selectorExpression = SubComActivityDetailPlanPassMqTagConstant.PASS_AUDIT_FEE_PREDICTION,
        /**
         * 相同分组下 consumer 可自动负载均衡
         * 请把consumerGroup  定义在 *** 内 需要统一维护
        */
        consumerGroup = SubComActivityDetailPlanPassMqTagConstant.PASS_AUDIT_FEE_PREDICTION + "${rocketmq.environment}",
        /**
         * 默认集群消费MqConstant
         * 可以设置 ConsumeMode.ORDERLY 使用广播消费
         * 也可使用集群模式模拟广播模式：
         * 启动多个不同 consumerGroup 的consumer实例
        */
        consumeMode = ConsumeMode.CONCURRENTLY,
        /**
         * 集群消费or广播消费;默认是集群消费
        */
        messageModel = MessageModel.CLUSTERING)
public class SubComActivityDetailPlanPassAuditFeePredictionConsumer extends AbstractRocketMqConsumer {

    @Autowired(required = false)
    private AuditFeePredictionService predictionService;

    @Autowired(required = false)
    private SubComActivityDetailPlanVoService subComActivityDetailPlanVoService;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private ActivityFormService activityFormService;

    @Override
    protected Object handleMessage(MqMessageVo message) {
        log.info("分子活动细案审批通过推送费用预测管理 order mq message received  : {}", message);
        if (Objects.isNull(message)
                || StringUtils.isEmpty(message.getMsgBody())) {
            return "消息为空!";
        }

        try {
            List<String> businessNoList = JSON.parseArray(message.getMsgBody(), String.class);
            List<SubComActivityDetailPlanVo> subDetailPlanList = subComActivityDetailPlanVoService.findDetailByPlanCodes(businessNoList);
            log.info("分子活动细案信息：{}",subDetailPlanList);
            if (CollectionUtils.isEmpty(subDetailPlanList)) {
                log.error("分子活动细案审批通过推送费用预测管理,未查询到分子活动细案!");
                return "未查询到分子活动细案！";
            }
            List<AuditFeePredictionDto> predictionDtoList = this.buildData(subDetailPlanList);
            if (CollectionUtils.isEmpty(predictionDtoList)) {
                log.error("分子活动细案审批通过推送费用预测管理,构建费用预测管理信息失败!");
                return "消费成功.";
            }
            log.info("分子活动细案审批通过推送费用预测管理,开始保存活动细案的费用预测管理:{}",predictionDtoList);
            predictionService.createBatch(predictionDtoList);
        }catch (Exception e){
            log.error(SubComActivityDetailPlanPassMqTagEnum.PASS_MATERIAL_PURCHASING_ORDER.getName()+"处理失败"+e.getMessage(),e);
            return "消费失败."+e.getMessage();
        }

        return "消费成功.";
    }

    private List<AuditFeePredictionDto> buildData(List<SubComActivityDetailPlanVo> subDetailPlanList) {
        List<AuditFeePredictionDto> predictionDtoList = Lists.newArrayList();
        if (Objects.isNull(subDetailPlanList)) {
            return predictionDtoList;
        }

        // 查询活动形式信息
        List<SubComActivityDetailPlanItemVo> itemList = Lists.newArrayList();
        subDetailPlanList.forEach(subComActivityDetailPlanVo -> {
            itemList.addAll(subComActivityDetailPlanVo.getItemList());
        });
        Map<String,SubComActivityDetailPlanVo> subComActivityDetailPlanVoMap = subDetailPlanList.stream().collect(Collectors.toMap(SubComActivityDetailPlanVo::getConstituentDetailPlanCode,Function.identity()));
        List<String> activityFormCodes = itemList.stream().map(SubComActivityDetailPlanItemVo::getActivityFormCode).collect(Collectors.toList());
        List<ActivityFormVo> activityFormVos = activityFormService.findByCodes(activityFormCodes);
        Map<String,ActivityFormVo> activityFormVoMap = activityFormVos.stream().collect(Collectors.toMap(ActivityFormVo::getActivityFormCode, Function.identity()));
        itemList.forEach(item ->{
            if (activityFormVoMap.containsKey(item.getActivityFormCode())) {
                ActivityFormVo activityFormVo = activityFormVoMap.get(item.getActivityFormCode());
                if (activityFormVo.getIsSupermarketDeductionItem()) {
                    AuditFeePredictionDto dto = this.nebulaToolkitService.copyObjectByWhiteList(item,AuditFeePredictionDto.class, HashSet.class, ArrayList.class);
                    dto.setId(null);
                    dto.setDataSource(DataSourceEnum.SON_ACTIVITY_DETAIL.getCode());
                    dto.setActivityYearMonth(item.getFeeYearMonth());
                    dto.setSystemCode(item.getResaleCommercialCode());
                    dto.setSystemName(item.getResaleCommercialName());
                    dto.setActivityBeginDate(item.getActivityBeginTime());
                    dto.setActivityEndDate(item.getActivityEndTime());
                    dto.setOrderBeginDate(item.getOrderStartDate());
                    dto.setDetailPlanItemCode(item.getConstituentDetailPlanItemCode());
                    dto.setDetailPlanCode(item.getConstituentDetailPlanCode());
                    dto.setDetailPlanName(item.getConstituentDetailPlanName());
                    dto.setApplyAmount(item.getTotalCost());
                    dto.setWholeAudit(YesOrNoEnum.NO.getCode());
                    dto.setRollbackBudgetTag(YesOrNoEnum.NO.getCode());
                    dto.setIsClose(YesOrNoEnum.NO.getCode());
                    if (StringUtils.isEmpty(dto.getSalesInstitutionCode())) {
                        if (subComActivityDetailPlanVoMap.containsKey(item.getConstituentDetailPlanCode())) {
                            dto.setSalesInstitutionCode(subComActivityDetailPlanVoMap.get(item.getConstituentDetailPlanCode()).getSalesInstitutionCode());
                            dto.setSalesInstitutionName(subComActivityDetailPlanVoMap.get(item.getConstituentDetailPlanCode()).getSalesInstitutionName());
                        }
                    }
                    predictionDtoList.add(dto);
                }
            }
        });
        return predictionDtoList;
    }

}
