package com.biz.crm.tpm.business.audit.fee.local.controller.auditFeeVerifyDecide;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.auditFeeVerifyDecide.AuditFeeVerifyDecideDto;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckDetailPlanVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeVerifyDecideService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.auditFeeVerifyDecide.AuditFeeVerifyDecideVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author ：dengwei
 * @date ：Created in 2022/12/8 15:35
 * @description：扣费核定表
 */
@Slf4j
@Api(tags = "扣费核定")
@RestController
@RequestMapping(value = {"/v1/AuditFeeVerifyDecide"})
public class AuditFeeVerifyDecideController {

    @Autowired(required = false)
    private AuditFeeCheckDetailPlanVoService auditFeeCheckDetailPlanVoService;

    @Autowired(required = false)
    private AuditFeeVerifyDecideService auditFeeVerifyDecideService;

    /**
     * 查询分页列表
     *
     * @param pageable
     * @param dto
     * @return
     */
    @ApiOperation(value = "查询分页列表")
    @GetMapping(value = {"/findByConditions"})
    public Result<Page<AuditFeeVerifyDecideVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                                 AuditFeeVerifyDecideDto dto) {
        try {
//            Page<AuditFeeVerifyDecideVo> result = this.auditFeeCheckDetailPlanVoService.findForFeeVerifyDecideByConditions(pageable, dto);
//            Page<AuditFeeVerifyDecideVo> result = this.auditFeeCheckDetailPlanVoService.findForFeeVerifyDecideByConditionsNew(pageable, dto);
            Page<AuditFeeVerifyDecideVo> result = this.auditFeeVerifyDecideService.findByConditions(pageable, dto);
            return Result.ok(result);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 下推核销单弹窗
     *
     * @param pageable
     * @param dto
     * @return
     */
    @ApiOperation(value = "下推核销单弹窗")
    @GetMapping(value = {"/pushAuditQuery"})
    public Result<Page<AuditFeeVerifyDecideVo>> pushAuditQuery(@PageableDefault(50) Pageable pageable,
                                                                 AuditFeeVerifyDecideDto dto) {
        try {
            Page<AuditFeeVerifyDecideVo> result = this.auditFeeVerifyDecideService.pushAuditQuery(pageable, dto);
            return Result.ok(result);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 下推核销单
     *
     * @param dto
     * @return {@link Result}<{@link ?}>
     */
    @ApiOperation("下推核销单")
    @PostMapping(value = "pushAudit")
    public Result<?> pushAudit(@RequestBody AuditFeeVerifyDecideDto dto){
        try {
//            this.auditFeeCheckDetailPlanVoService.pushAudit(idList);
            //this.auditFeeCheckDetailPlanVoService.pushAuditNew(dto);
            this.auditFeeVerifyDecideService.pushAudit(dto);
            return Result.ok();
        }catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 编辑是否完全结案
     *
     * @param dto
     * @return
     */
    @ApiOperation("编辑是否完全结案")
    @PatchMapping(value = "updateWholeAudit")
    public Result<?> updateWholeAudit(@RequestBody AuditFeeVerifyDecideDto dto){
        try {
            this.auditFeeVerifyDecideService.updateWholeAudit(dto);
            return Result.ok();
        }catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
