package com.biz.crm.tpm.business.audit.fee.local.controller.check;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeCheckDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeCheckSelectDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeMatchDto;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 核销费用核对主表(AuditFeeCheck)表控制层
 *
 * @author makejava
 * @date 2022-11-14 16:56:09
 */
@Slf4j
@Api(tags = "核销费用核对主表")
@RestController
@RequestMapping(value = {"/v1/auditFeeCheck/auditFeeCheck"})
public class AuditFeeCheckController {

    @Resource
    private AuditFeeCheckVoService auditFeeCheckVoService;

    /**
     * 根据条件查询
     *
     * @param pageable      可分页
     * @param paginationDto 分页dto
     * @return {@link Result}<{@link Page}<{@link AuditFeeCheckVo}>>
     */
    @ApiOperation(value = "查询分页列表")
    @GetMapping(value = {"/findByConditions"})
    public Result<Page<AuditFeeCheckVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                          AuditFeeCheckDto paginationDto) {
        try {
            Page<AuditFeeCheckVo> result = this.auditFeeCheckVoService.findByConditions(pageable, paginationDto);
            return Result.ok(result);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 详情
     *
     * @param id id
     * @return {@link Result}<{@link AuditFeeCheckVo}>
     */
    @ApiOperation(value = "详情")
    @GetMapping(value = {"/findDetailById"})
    public Result<AuditFeeCheckVo> findDetailById(@RequestParam("id") String id) {
        try {
            AuditFeeCheckVo auditFeeCheckVo = this.auditFeeCheckVoService.findDetailById(id);
            return Result.ok(auditFeeCheckVo);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 修改
     * 更新
     *
     * @param auditFeeCheckVo 费用核对vo
     * @return {@link Result}<{@link AuditFeeCheckVo}>
     */
    @ApiOperation(value = "更新")
    @PatchMapping(value = "")
    public Result<AuditFeeCheckVo> update(@RequestBody AuditFeeCheckVo auditFeeCheckVo) {
        try {
            AuditFeeCheckVo current = this.auditFeeCheckVoService.update(auditFeeCheckVo, true);
            return Result.ok(current);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 启用
     *
     * @param ids id
     * @return {@link Result}
     */
    @ApiOperation(value = "启用")
    @PatchMapping("/enable")
    public Result enable(@RequestBody List<String> ids) {
        try {
            this.auditFeeCheckVoService.enableBatch(ids);
            return Result.ok("启用成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 禁用
     *
     * @param ids id
     * @return {@link Result}
     */
    @ApiOperation(value = "禁用")
    @PatchMapping("/disable")
    public Result disable(@RequestBody List<String> ids) {
        try {
            this.auditFeeCheckVoService.disableBatch(ids);
            return Result.ok("禁用成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 删除
     * 逻辑删除
     *
     * @param ids id
     * @return {@link Result}
     */
    @ApiOperation(value = "逻辑删除")
    @DeleteMapping("/delete")
    public Result delete(@RequestParam("ids") List<String> ids) {
        try {
            this.auditFeeCheckVoService.updateDelFlagByIds(ids);
            return Result.ok("删除成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 抽取核对数据
     *
     * @param auditFeeMatchDto 费用核对匹配dto
     * @return {@link Result}<{@link ?}>
     */
    @ApiOperation(value = "抽取核对数据")
    @PostMapping(value = "/pullKmsData")
    public Result<?> pullKmsData(@RequestBody AuditFeeMatchDto auditFeeMatchDto) {
        try {
            this.auditFeeCheckVoService.pullKmsData(auditFeeMatchDto);
            return Result.ok("操作成功,正在获取数据中...");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 抽取核对数据定时任务
     *
     * @return {@link Result}<{@link ?}>
     */
    @ApiOperation(value = "抽取核对数据定时任务")
    @PostMapping(value = "/pullKmsDataAndMatchTask")
    public Result<?> pullKmsDataAndMatchTask() {
        try {
            this.auditFeeCheckVoService.pullKmsDataAndMatchTask();
            return Result.ok("操作成功,正在获取数据中...");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 手工匹配
     *
     * @param auditFeeMatchDto 费用核对匹配dto
     * @return {@link Result}<{@link ?}>
     */
    @ApiOperation(value = "手工匹配")
    @PostMapping(value = "/matchFee")
    public Result<?> matchFee(@RequestBody AuditFeeMatchDto auditFeeMatchDto) {
        try {
            this.auditFeeCheckVoService.manualMatchFee(auditFeeMatchDto);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 手工执行匹配任务
     */
    @ApiOperation(value = "手工执行匹配任务")
    @GetMapping(value = "/executeJob")
    public Result<?> executeJob() {
        try {
            this.auditFeeCheckVoService.matchJob();
            return Result.ok("操作成功,正在匹配中...");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 确认
     *
     * @return {@link Result}
     */
    @ApiOperation(value = "确认")
    @PatchMapping("/confirm")
    public Result confirm(@RequestBody AuditFeeCheckVo auditFeeCheckVo) {
        try {
            this.auditFeeCheckVoService.confirm(auditFeeCheckVo);
            return Result.ok("确认成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 确认差异
     * 需要传入被抵扣的差异费用台账，并更新差异台账那边数据
     * @param vo
     * @return {@link Result}
     */
    @ApiOperation(value = "确认差异")
    @PatchMapping("/confirmDiff")
    public Result confirmDiff(@RequestBody AuditFeeCheckVo vo) {
        try {
            this.auditFeeCheckVoService.confirmDiff(vo);
            return Result.ok("确认差异成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 根据页面调整计算差异
     * 用于页面联动，不保存数据
     * 需要传入页面选的费用，细案
     * @param vo
     * @return {@link Result}
     */
    @ApiOperation(value = "根据页面调整计算差异")
    @PatchMapping("/compute")
    public Result compute(@RequestBody AuditFeeCheckVo vo) {
        try {
            return Result.ok(this.auditFeeCheckVoService.compute(vo));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 取消匹配
     *
     * @param id id
     * @return {@link Result}
     */
    @ApiOperation(value = "取消匹配")
    @PatchMapping("/cancelingMatch")
    public Result cancelingMatch(@RequestBody String id) {
        try {
            this.auditFeeCheckVoService.cancelingMatch(id);
            return Result.ok("取消匹配成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 设置备注
     *
     * @param id   id
     * @param note 备注
     * @return {@link Result}
     */
    @ApiOperation(value = "设置备注")
    @PatchMapping("/note")
    public Result updateNote(@RequestParam(value = "id") String id,@RequestBody String note) {
        try {
            this.auditFeeCheckVoService.updateNote(id,note);
            return Result.ok("操作成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 牛E财通查询费用核对数据
     *
     * @param pageable      可分页
     * @param dto 分页dto
     * @return {@link Result}<{@link Page}<{@link AuditFeeCheckVo}>>
     */
    @ApiOperation(value = "牛E财通查询费用核对数据")
    @GetMapping(value = {"/findByConditionsForEct"})
    public Result<Page<AuditFeeCheckVo>> findByConditionsForEct(@PageableDefault(50) Pageable pageable,
                                                          AuditFeeCheckSelectDto dto) {
        try {
            Page<AuditFeeCheckVo> result = this.auditFeeCheckVoService.findByConditionsForEct(pageable, dto);
            return Result.ok(result);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * pos-细案费用汇总更新
     *
     * @param matchCode
     * @return
     */
    @ApiOperation(value = "pos-细案费用汇总更新")
    @PostMapping(value = "/posActivityAmountSummary")
    public Result<?> posActivityAmountSummary(@RequestParam("matchCode") String matchCode) {
        try {
            this.auditFeeCheckVoService.posActivityAmountSummary(true,null,matchCode);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 刷新细案分摊
     * 只计算，不写入，与compute()方法协同
     * @param auditFeeCheckVo
     * @return
     */
    @ApiOperation(value = "刷新细案分摊")
    @PostMapping(value = "/detailPlanReshare")
    public Result<?> detailPlanReshare(@RequestBody AuditFeeCheckVo auditFeeCheckVo) {
        try {
            this.auditFeeCheckVoService.detailPlanReshare(auditFeeCheckVo);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
