package com.biz.crm.tpm.business.audit.fee.local.controller.check;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeCheckCostDto;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckCostVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckCostVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

/**
 * 核销费用核对主表(AuditFeeCheck)表控制层
 *
 * @author makejava
 * @date 2022-11-14 16:56:09
 */
@Slf4j
@Api(tags = "核销费用核对关联费用单单表(数据源至KMS)")
@RestController
@RequestMapping(value = {"/v1/auditFeeCheckCost/auditFeeCheckCost"})
public class AuditFeeCheckCostController {

    @Resource
    private AuditFeeCheckCostVoService auditFeeCheckCostVoService;

    /**
     * 查询分页列表
     *
     * @param pageable      可分页
     * @param paginationDto 分页dto
     * @return {@link Result}<{@link Page}<{@link AuditFeeCheckCostVo}>>
     */
    @ApiOperation(value = "查询分页列表")
    @GetMapping(value = {"/findByConditions"})
    public Result<Page<AuditFeeCheckCostVo>> findByConditions(@PageableDefault(50) Pageable pageable, AuditFeeCheckCostDto paginationDto) {
        try {
            Page<AuditFeeCheckCostVo> result = this.auditFeeCheckCostVoService.findByConditions(pageable, paginationDto);
            return Result.ok(result);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

}
