package com.biz.crm.tpm.business.audit.fee.local.controller.check;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeCheckDetailPlanDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.prediction.AuditFeePredictionDto;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckDetailPlanVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckDetailPlanVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

/**
 * 核销费用核对关联细案表(AuditFeeCheckDetailPlan)表控制层
 *
 * @author makejava
 * @date 2022-12-06 14:19:03
 */
@Slf4j
@Api(tags = "核销费用核对关联细案表")
@RestController
@RequestMapping(value = {"/v1/auditFeeCheckDetailPlan/auditFeeCheckDetailPlan"})
public class AuditFeeCheckDetailPlanController {

    @Autowired(required = false)
    private AuditFeeCheckDetailPlanVoService auditFeeCheckDetailPlanVoService;

    /**
     * 查询扣费预测细案细类分页列表
     *
     * @param pageable
     * @param paginationDto
     * @return
     */
    @ApiOperation(value = "查询扣费预测细案细类分页列表")
    @GetMapping(value = {"/findDetailPlanByConditions"})
    public Result<Page<AuditFeeCheckDetailPlanVo>> findDetailPlanByConditions(@PageableDefault(50) Pageable pageable, AuditFeePredictionDto paginationDto) {
        try {
            Page<AuditFeeCheckDetailPlanVo> result = this.auditFeeCheckDetailPlanVoService.findDetailPlanByConditions(pageable, paginationDto);
            return Result.ok(result);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
