package com.biz.crm.tpm.business.audit.fee.local.controller.check;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckDetailPlanVoCacheService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckDetailPlanVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 费用核对关联细案明细表缓存控制层")
 *
 * @author makejava
 * @date 2022-11-28 15:27:55
 */
@Slf4j
@Api(tags = "费用核对关联细案明细缓存控制层")
@RestController
@RequestMapping(value = {"/v1/auditFeeCheckDetailPlanItemCache/auditFeeCheckDetailPlanItemCache"})
public class AuditFeeCheckDetailPlanItemCacheController {

    @Autowired(required = false)
    private AuditFeeCheckDetailPlanVoCacheService auditFeeCheckDetailPlanVoCacheService;


    /**
     * 1、获取明细列表缓存分页接口
     *
     * @param pageable 分页参数
     * @param cacheKey 缓存key
     */
    @ApiOperation(value = "1.获取明细列表缓存分页接口")
    @GetMapping("findCachePageList")
    public Result<Page<AuditFeeCheckDetailPlanVo>> findCachePageList(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                          @ApiParam(name = "cacheKey", value = "缓存键") @RequestParam String cacheKey,
                                                                          @ApiParam(name = "matchCode", value = "策略编码") @RequestParam(required = false) String matchCode) {
        try {
            Page<AuditFeeCheckDetailPlanVo> page = this.auditFeeCheckDetailPlanVoCacheService.findCachePageList(pageable, cacheKey, matchCode);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 2、新增一行接口，保存当前页数据后，在缓存中行首插入一条数据并返回第一页数据
     *
     * @param pageable 分页参数
     * @param cacheKey 缓存key
     * @param itemList 要保存的当前页数据
     */
    @ApiOperation(value = "2.新增一行接口，在缓存中行首插入一条数据并返回第一页数据")
    @PostMapping("addItemCache")
    public Result<Page<AuditFeeCheckDetailPlanVo>> addItemCache(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                     @ApiParam(name = "cacheKey", value = "缓存键") @RequestParam String cacheKey,
                                                                     @ApiParam(value = "当前页数据") @RequestBody List<AuditFeeCheckDetailPlanVo> itemList) {
        try {
            this.auditFeeCheckDetailPlanVoCacheService.addItemCache(cacheKey, itemList);
            Page<AuditFeeCheckDetailPlanVo> page = this.auditFeeCheckDetailPlanVoCacheService.findCachePageList(pageable, cacheKey, null);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 3、复制行接口，保存当前页数据后，在缓存中行首复制选中数据并返回第一页数据
     *
     * @param pageable 分页参数
     * @param cacheKey 缓存key
     */
    @ApiOperation(value = "3.复制行接口，保存当前页数据后，在缓存中行首复制选中数据并返回第一页数据")
    @PostMapping("copyItemListCache")
    public Result<Page<AuditFeeCheckDetailPlanVo>> copyItemListCache(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                          @ApiParam(name = "cacheKey", value = "缓存键") @RequestParam String cacheKey,
                                                                          @ApiParam(value = "要复制的行id集合") @RequestBody List<AuditFeeCheckDetailPlanVo> itemList) {
        try {
            this.auditFeeCheckDetailPlanVoCacheService.copyItemListCache(cacheKey, itemList);
            Page<AuditFeeCheckDetailPlanVo> page = this.auditFeeCheckDetailPlanVoCacheService.findCachePageList(pageable, cacheKey, null);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 4、保存当前页数据到缓存并返回指定页数据接口
     *
     * @param pageable 分页参数
     * @param cacheKey 缓存key
     */
    @ApiOperation(value = "4.保存当前页数据到缓存并返回指定页数据接口")
    @PostMapping("saveCurrentPageCache")
    public Result<Page<AuditFeeCheckDetailPlanVo>> saveCurrentPageCache(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                             @ApiParam(name = "cacheKey", value = "缓存键") @RequestParam String cacheKey,
                                                                             @ApiParam(value = "当前页数据") @RequestBody List<AuditFeeCheckDetailPlanVo> saveList) {
        try {
            this.auditFeeCheckDetailPlanVoCacheService.saveCurrentPageCache(cacheKey, saveList);
            Page<AuditFeeCheckDetailPlanVo> page = this.auditFeeCheckDetailPlanVoCacheService.findCachePageList(pageable, cacheKey, null);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 5、获取缓存中的所有明细行
     *
     * @param cacheKey 缓存key
     */
    @ApiOperation(value = "5.获取缓存中的所有明细行")
    @PostMapping("findCacheList")
    public Result<List<AuditFeeCheckDetailPlanVo>> findCacheList(@ApiParam(name = "cacheKey", value = "缓存键") @RequestParam String cacheKey) {
        try {
            return Result.ok(this.auditFeeCheckDetailPlanVoCacheService.findCacheList(cacheKey));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 6、清理缓存接口
     *
     * @param cacheKey 缓存key
     */
    @ApiOperation(value = "6.清理缓存接口")
    @PostMapping("clearCache")
    public Result<?> clearCache(@ApiParam(name = "cacheKey", value = "缓存键") @RequestParam String cacheKey) {
        try {
            this.auditFeeCheckDetailPlanVoCacheService.clearCache(cacheKey);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 7、多行删除并返回指定页数据接口
     *
     * @param pageable 分页参数
     * @param cacheKey 缓存key
     */
    @ApiOperation(value = "7.多行删除并返回指定页数据接口")
    @PostMapping("deleteCacheList")
    public Result<Page<AuditFeeCheckDetailPlanVo>> deleteCacheList(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                        @ApiParam(name = "cacheKey", value = "缓存键") @RequestParam String cacheKey,
                                                                        @ApiParam(name = "deleteIds", value = "要删除的行id集合") @RequestBody List<String> deleteIds) {
        try {
            this.auditFeeCheckDetailPlanVoCacheService.deleteCacheList(cacheKey, deleteIds);
            Page<AuditFeeCheckDetailPlanVo> page = this.auditFeeCheckDetailPlanVoCacheService.findCachePageList(pageable, cacheKey, null);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }



}
