package com.biz.crm.tpm.business.audit.fee.local.controller.check;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeCheckDiffDto;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckDiffVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckDiffVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.ledger.AuditFeeDiffLedgerVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 核销费用核对关联费用差异表
 *
 * @author makejava
 * @date 2022-11-14 16:56:09
 */
@Slf4j
@Api(tags = "核销费用核对关联费用差异表")
@RestController
@RequestMapping(value = {"/v1/auditFeeCheckDiff/auditFeeCheckDiff"})
public class AuditFeeCheckDiffController {

    @Resource
    private AuditFeeCheckDiffVoService auditFeeCheckDiffVoService;

    /**
     * 查询分页列表 核对暂时保存的费用差异
     *
     * @param pageable      可分页
     * @param paginationDto 分页dto
     * @return {@link Result}<{@link Page}<{@link AuditFeeCheckDiffDto}>>
     */
    @ApiOperation(value = "查询分页列表")
    @GetMapping(value = {"/findByConditions"})
    public Result<Page<AuditFeeCheckDiffVo>> findByConditions(@PageableDefault(50) Pageable pageable, AuditFeeCheckDiffDto paginationDto) {
        try {
            Page<AuditFeeCheckDiffVo> result = this.auditFeeCheckDiffVoService.findByConditions(pageable, paginationDto);
            return Result.ok(result);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 查询分页列表 差异费用台账
     * 必传 业态，业务单元
     * @param pageable      可分页
     * @param paginationDto 分页dto
     * @return {@link Result}<{@link Page}<{@link AuditFeeCheckDiffDto}>>
     */
    @ApiOperation(value = "查询分页列表")
    @GetMapping(value = {"/findDiffLedgerByConditions"})
    public Result<Page<AuditFeeCheckDiffVo>> findDiffLedgerByConditions(@PageableDefault(50) Pageable pageable, AuditFeeCheckDiffDto paginationDto) {
        try {
            Page<AuditFeeCheckDiffVo> result = this.auditFeeCheckDiffVoService.findDiffLedgerByConditions(pageable, paginationDto);
            return Result.ok(result);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

}
