package com.biz.crm.tpm.business.audit.fee.local.controller.check;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.audit.fee.local.service.AuditFeeCheckPosPullKmsDataService;
import com.biz.crm.tpm.business.audit.fee.local.service.AuditFeeCheckPosService;
import com.biz.crm.tpm.business.audit.fee.sdk.constants.AuditFeeConstants;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeCheckPosDto;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckPosVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckPosVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto.SubComActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import jodd.util.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.*;

import java.util.Date;
import java.util.List;

/**
 * @Description:核销费用核对Pos表(AuditFeeCheckPos)控制层
 * @Author qiancheng
 * @Date 2023/5/29
 */
@Slf4j
@Api(tags = "核销费用核对Pos表控制层")
@RestController
@RequestMapping(value = {"/v1/auditFeeCheckPos/auditFeeCheckPos"})
public class AuditFeeCheckPosController {

    @Autowired(required = false)
    private AuditFeeCheckPosService auditFeeCheckPosService;

    @Autowired(required = false)
    private AuditFeeCheckPosVoService auditFeeCheckPosVoService;

    @Autowired(required = false)
    private AuditFeeCheckPosPullKmsDataService auditFeeCheckPosPullKmsDataService;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Autowired(required = false)
    private RedisService redisService;

    /**
     * 分页查询费用核对Pos数据
     *
     * @param pageable 分页对象
     * @param dto      实体对象
     * @return 分页数据
     */
    @ApiOperation(value = "分页查询费用核对Pos数据")
    @GetMapping("/findByConditions")
    public Result<Page<AuditFeeCheckPosVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(20) Pageable pageable,
                                                             @ApiParam(name = "dto", value = "费用核对Pos数据") AuditFeeCheckPosDto dto) {
        try {
            Page<AuditFeeCheckPosVo> page = this.auditFeeCheckPosVoService.findByConditions(pageable, dto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 活动明细分页
     *
     * @param dto
     * @return
     */
    @ApiOperation(value = "活动明细分页")
    @GetMapping("/findActivityDetailPlanItemPage")
    public Result<Page<ActivityDetailPlanItemVo>> findActivityDetailPlanItemPage(
            @ApiParam(name = "pageable", value = "分页对象") @PageableDefault(20) Pageable pageable,
            @ApiParam(name = "dto", value = "详情") @RequestBody ActivityDetailPlanItemDto dto) {
        try {
            Page<ActivityDetailPlanItemVo> page = this.auditFeeCheckPosService.findActivityDetailPlanItemPage(pageable, dto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 分子活动明细分页
     *
     * @param dto
     * @return
     */
    @ApiOperation(value = "分子活动明细分页")
    @GetMapping("/findSubComActivityDetailPlanItemPage")
    public Result<Page<SubComActivityDetailPlanItemVo>> findSubComActivityDetailPlanItemPage(
            @ApiParam(name = "pageable", value = "分页对象") @PageableDefault(20) Pageable pageable,
            @ApiParam(name = "dto", value = "详情") @RequestBody SubComActivityDetailPlanItemDto dto) {
        try {
            Page<SubComActivityDetailPlanItemVo> page = this.auditFeeCheckPosService.findSubComActivityDetailPlanItemPage(pageable, dto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 更新
     *
     * @param dto
     * @return
     */
    @ApiOperation(value = "更新")
    @PatchMapping
    public Result<?> update(@ApiParam(name = "dto", value = "对象") @RequestBody AuditFeeCheckPosDto dto) {
        try {
            this.auditFeeCheckPosService.update(dto);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 详情
     *
     * @param id 主键
     * @return
     */
    @ApiOperation(value = "详情")
    @GetMapping(value = "/findByIdOrCode")
    public Result<AuditFeeCheckPosVo> findByIdOrCode(@ApiParam(name = "id", value = "主键") @RequestParam(value = "id", required = false) String id,
                                                     @ApiParam(name = "matchCode", value = "扣费匹配单号") @RequestParam(value = "matchCode", required = false) String matchCode) {
        try {
            return Result.ok(this.auditFeeCheckPosVoService.findByIdOrCode(id, matchCode));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 编辑备注
     *
     * @param dto 费用核对vo
     * @return
     */
    @ApiOperation(value = "编辑备注")
    @PostMapping(value = "/updateRemark")
    public Result<?> updateRemark(@ApiParam(name = "dto", value = "pos") @RequestBody AuditFeeCheckPosDto dto) {
        try {
            this.auditFeeCheckPosVoService.updateRemark(dto);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 取消匹配
     *
     * @param dto 费用核对vo
     * @return
     */
    @ApiOperation(value = "取消匹配")
    @PostMapping(value = "/cancelMatch")
    public Result<?> cancelMatch(@ApiParam(name = "dto", value = "pos") @RequestBody AuditFeeCheckPosDto dto) {
        try {
            this.auditFeeCheckPosVoService.cancelMatch(dto);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 差异核对获取数据
     *
     * @param ids 差异核对
     * @return
     */
    @ApiOperation(value = "差异核对获取数据")
    @PostMapping(value = "/findDiffCheckDataList")
    public Result<List<AuditFeeCheckPosVo>> findDiffCheckDataList(@ApiParam(name = "ids", value = "主键集合") @RequestBody List<String> ids) {
        try {
            return Result.ok(this.auditFeeCheckPosVoService.findDiffCheckDataList(ids));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 暂存
     *
     * @param dtoList 费用核对vo
     * @return
     */
    @ApiOperation(value = "暂存")
    @PostMapping(value = "/tempSave")
    public Result<?> tempSave(@ApiParam(name = "dtoList", value = "数据集合") @RequestBody List<AuditFeeCheckPosDto> dtoList) {
        try {
            this.auditFeeCheckPosVoService.tempSave(dtoList);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 确认匹配
     *
     * @param dtoList 费用核对vo
     * @return
     */
    @ApiOperation(value = "确认匹配")
    @PostMapping(value = "/sureMatch")
    public Result<?> sureMatch(@ApiParam(name = "dtoList", value = "数据集合") @RequestBody List<AuditFeeCheckPosDto> dtoList) {
        try {
            this.auditFeeCheckPosVoService.sureMatch(dtoList);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 匹配活动
     *
     * @param dto 费用核对vo
     * @return
     */
    @ApiOperation(value = "匹配活动")
    @PostMapping(value = "/matchActivity")
    public Result<?> matchActivity(@ApiParam(name = "dto", value = "数据集合") @RequestBody AuditFeeCheckPosDto dto) {
        try {
            this.auditFeeCheckPosVoService.matchActivity(dto);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 手动拉取KMS的POS数据
     *
     * @param beginDateStr
     * @param endDateStr
     * @return com.biz.crm.business.common.sdk.model.Result<?>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2023-10-04 17:01
     */
    @ApiOperation(value = "手动拉取KMS数据")
    @GetMapping(value = "/pullKmsDataAsync")
    public Result<?> pullKmsDataAsync(@ApiParam(name = "beginDateStr", value = "POS数据修改时间开始") @RequestParam("beginDateStr") String beginDateStr,
                                      @ApiParam(name = "endDateStr", value = "POS数据修改时间结束") @RequestParam(value = "endDateStr", required = false) String endDateStr) {
        try {
            Date beginDate = DateUtil.parseDate(beginDateStr, DateUtil.DEFAULT_YEAR_MONTH_DAY);
            Assert.notNull(beginDate, "开始时间不合法,格式须为[" + DateUtil.DEFAULT_YEAR_MONTH_DAY + "]!");
            Date endDate = null;
            if (StringUtil.isNotEmpty(endDateStr)) {
                endDate = DateUtil.parseDate(endDateStr, DateUtil.DEFAULT_YEAR_MONTH_DAY);
                Assert.notNull(endDate, "结束时间不合法,格式须为[" + DateUtil.DEFAULT_YEAR_MONTH_DAY + "]!");
            }
            String yearMonthDay = DateUtil.format(new Date(), DateUtil.DEFAULT_YEAR_MONTH_DAY);
            String lockKey = AuditFeeConstants.AUDIT_FEE_UPDATE_KMS_POS_LOCK + yearMonthDay;
            boolean hasKey = this.redisService.hasKey(lockKey);
            Assert.isTrue(!hasKey, "上次操作[" + yearMonthDay + "]还未完成,本次不执行!");
            AbstractCrmUserIdentity userIdentity = loginUserService.getAbstractLoginUser();
            this.auditFeeCheckPosPullKmsDataService.pullKmsDataAsync(userIdentity, beginDateStr, endDateStr);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


}
