package com.biz.crm.tpm.business.audit.fee.local.controller.check;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeCheckPosHeadDto;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckPosHeadVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckPosHeadVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Description:核销费用核对Pos表(AuditFeeCheckPos)控制层
 * @Author qiancheng
 * @Date 2023/5/29
 */
@Slf4j
@Api(tags = "核销费用核对Pos汇总表控制层")
@RestController
@RequestMapping(value = {"/v1/auditFeeCheckPosHead/auditFeeCheckPosHead"})
public class AuditFeeCheckPosHeadController {

    @Autowired(required = false)
    private AuditFeeCheckPosHeadVoService auditFeeCheckPosHeadVoService;

    /**
     * 分页查询费用核对Pos汇总数据
     *
     * @param pageable 分页对象
     * @param dto      实体对象
     * @return 分页数据
     */
    @ApiOperation(value = "分页查询费用核对Pos数据")
    @GetMapping("/findByConditions")
    public Result<Page<AuditFeeCheckPosHeadVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(20) Pageable pageable,
                                                                 @ApiParam(name = "dto", value = "费用核对Pos数据") AuditFeeCheckPosHeadDto dto) {
        try {
            Page<AuditFeeCheckPosHeadVo> page = this.auditFeeCheckPosHeadVoService.findByConditions(pageable, dto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 详情
     *
     * @param id 主键
     * @return
     */
    @ApiOperation(value = "详情")
    @GetMapping(value = "/findByIdOrCode")
    public Result<AuditFeeCheckPosHeadVo> findByIdOrCode(@ApiParam(name = "id", value = "主键") @RequestParam(value = "id", required = false) String id,
                                                         @ApiParam(name = "matchHeadCode", value = "扣费匹配汇总单号") @RequestParam(value = "matchHeadCode", required = false) String matchHeadCode) {
        try {
            return Result.ok(this.auditFeeCheckPosHeadVoService.findByIdOrCode(id, matchHeadCode));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

}
