package com.biz.crm.tpm.business.audit.fee.local.controller.check;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeCheckStatementDto;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckStatementVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckStatementVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

/**
 * 核销费用核对关联结算单单表(数据源至KMS)(AuditFeeCheckStatement)表控制层
 *
 * @author makejava
 * @date 2022-12-06 14:20:23
 */
@Slf4j
@Api(tags = "核销费用核对关联结算单单表(数据源至KMS)")
@RestController
@RequestMapping(value = {"/v1/auditFeeCheckStatement/auditFeeCheckStatement"})
@Deprecated
public class AuditFeeCheckStatementController {

    @Autowired(required = false)
    private AuditFeeCheckStatementVoService auditFeeCheckStatementVoService;

    /**
     * 查询分页列表
     *
     * @param pageable      可分页
     * @param paginationDto 分页dto
     * @return {@link Result}<{@link Page}<{@link AuditFeeCheckStatementVo}>>
     */
    @ApiOperation(value = "查询分页列表")
    @GetMapping(value = {"/findByConditions"})
    public Result<Page<AuditFeeCheckStatementVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                                   AuditFeeCheckStatementDto paginationDto) {
        try {
            Page<AuditFeeCheckStatementVo> result = this.auditFeeCheckStatementVoService.findByConditions(pageable, paginationDto);
            return Result.ok(result);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


}
