package com.biz.crm.tpm.business.audit.fee.local.controller.dispose;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.audit.fee.sdk.constants.AuditFeeConstants;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.dispose.AuditFeeDiffDisposeCorrelationDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.dispose.AuditFeeDiffDisposeDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.dispose.AuditFeeDiffDisposeProcessDto;
import com.biz.crm.tpm.business.audit.fee.sdk.service.dispose.AuditFeeDiffDisposeVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.dispose.AuditFeeDiffDisposeVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.constant.SubComActivityDesignConstant;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import java.util.List;
import java.util.concurrent.TimeUnit;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 核销差异费用处理(AuditFeeDiffDispose)表控制层
 *
 * @author liuyifan
 * @date 2022-12-24 13:54:27
 */
@Slf4j
@Api(tags = "核销差异费用处理")
@RestController
@RequestMapping(value = {"/v1/auditFeeDiffDispose/auditFeeDiffDispose"})
public class AuditFeeDiffDisposeController {

    @Autowired(required = false)
    private AuditFeeDiffDisposeVoService auditFeeDiffDisposeVoService;

    @Autowired(required = false)
    private RedisMutexService redisMutexService;

    /**
     * 查询分页列表
     *
     * @param pageable
     * @param paginationDto
     * @return
     */
    @ApiOperation(value = "查询分页列表")
    @GetMapping(value = {"/findByConditions"})
    public Result<Page<AuditFeeDiffDisposeVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                                AuditFeeDiffDisposeDto paginationDto) {
        try {
            Page<AuditFeeDiffDisposeVo> result = this.auditFeeDiffDisposeVoService.findByConditions(pageable, paginationDto);
            return Result.ok(result);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 详情
     *
     * @param id
     * @return
     */
    @ApiOperation(value = "详情")
    @GetMapping(value = {"/findDetailById"})
    public Result<AuditFeeDiffDisposeVo> findDetailById(@RequestParam("id") String id) {
        try {
            AuditFeeDiffDisposeVo auditFeeDiffDisposeVo = this.auditFeeDiffDisposeVoService.findDetailById(id);
            return Result.ok(auditFeeDiffDisposeVo);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 创建
     *
     * @param dto
     * @return
     */
    @ApiOperation(value = "创建")
    @PostMapping(value = "")
    public Result<?> create(@RequestParam(value = "cacheKey") String cacheKey,@RequestBody AuditFeeDiffDisposeDto dto) {
        try {
            this.auditFeeDiffDisposeVoService.create(cacheKey,dto);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 更新
     *
     * @param dto
     * @return
     */
    @ApiOperation(value = "更新")
    @PatchMapping(value = "")
    public Result<?> update(@RequestParam(value = "cacheKey") String cacheKey,@RequestBody AuditFeeDiffDisposeDto dto) {
        try {
            this.auditFeeDiffDisposeVoService.update(cacheKey,dto);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 启用
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "启用")
    @PatchMapping("/enable")
    public Result enable(@RequestBody List<String> ids) {
        try {
            this.auditFeeDiffDisposeVoService.enableBatch(ids);
            return Result.ok("启用成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 禁用
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "禁用")
    @PatchMapping("/disable")
    public Result disable(@RequestBody List<String> ids) {
        try {
            this.auditFeeDiffDisposeVoService.disableBatch(ids);
            return Result.ok("禁用成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 逻辑删除
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "逻辑删除")
    @DeleteMapping("/delete")
    public Result delete(@RequestParam("ids") List<String> ids) {
        try {
            this.auditFeeDiffDisposeVoService.updateDelFlagByIds(ids);
            return Result.ok("删除成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 批量提交审批流
     *
     * @param dto 批量提交审批流dto
     * @return
     */
    @ApiOperation(value = "批量提交审批流")
    @PatchMapping("/submitBatchProcess")
    public Result<?> submitBatchProcess(@RequestBody AuditFeeDiffDisposeProcessDto dto) {

        List<String> lockSuccessKeyList = Lists.newArrayList();
        try {
            if (CollectionUtils.isEmpty(dto.getIds())){
                throw new RuntimeException("请选择数据！");
            }
            //提交审批前加锁一个小时
            for (String id : dto.getIds()) {
                String lockKey = AuditFeeConstants.AUDIT_FEE_DIFF_DISPOSE_APPROVE + id;
                boolean lockSuccess = redisMutexService.tryLock(lockKey, TimeUnit.HOURS, 1);
                if (lockSuccess){
                    lockSuccessKeyList.add(lockKey);
                }
            }
            this.auditFeeDiffDisposeVoService.submitBatchProcess(dto);
            return Result.ok("提交成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        } finally {
            if (!CollectionUtils.isEmpty(lockSuccessKeyList)){
                for (String lockSuccessKey : lockSuccessKeyList) {
                    redisMutexService.unlock(lockSuccessKey);
                }
            }
        }
    }

    /**
     * 关联差异费用
     * @param correlationDto
     * @return {@link Result}<{@link ?}>
     */
    @ApiOperation(value = "关联差异费用")
    @PatchMapping("/correlation")
    public Result<?> correlation(@RequestBody AuditFeeDiffDisposeCorrelationDto correlationDto){
        try {
            this.auditFeeDiffDisposeVoService.correlation(correlationDto);
            return Result.ok("提交成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
