package com.biz.crm.tpm.business.audit.fee.local.controller.dispose;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.common.base.dto.CommonSelectDto;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import com.biz.crm.mn.common.page.cache.controller.MnPageCacheController;
import com.biz.crm.mn.common.page.cache.service.MnPageCacheService;
import com.biz.crm.tpm.business.activities.template.config.sdk.dto.ActivitiesTemplateConfigDto;
import com.biz.crm.tpm.business.activities.template.config.sdk.enums.ActivitiesTemplateConfigTypeEnum;
import com.biz.crm.tpm.business.activities.template.config.sdk.service.ActivitiesTemplateSdkService;
import com.biz.crm.tpm.business.activities.template.config.sdk.vo.ActivitiesTemplateConfigVo;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.dispose.AuditFeeDiffDisposeDetailDto;
import com.biz.crm.tpm.business.audit.fee.sdk.service.dispose.AuditFeeDiffDisposeDetailVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.dispose.AuditFeeDiffDisposeLedgerVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.dispose.AuditFeeDiffDisposeDetailVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import java.util.List;

import io.swagger.annotations.ApiParam;
import liquibase.pro.packaged.S;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 核销差异费用处理明细(AuditFeeDiffDisposeDetail)表控制层
 *
 * @author liuyifan
 * @date 2022-12-24 13:56:11
 */
@Slf4j
@Api(tags = "核销差异费用处理明细")
@RestController
@RequestMapping(value = {"/v1/auditFeeDiffDisposeDetail/auditFeeDiffDisposeDetail"})
public class AuditFeeDiffDisposeDetailController extends MnPageCacheController<AuditFeeDiffDisposeDetailVo,AuditFeeDiffDisposeDetailDto> {

    @Autowired(required = false)
    private AuditFeeDiffDisposeDetailVoService auditFeeDiffDisposeDetailVoService;

    @Autowired
    private ActivitiesTemplateSdkService activitiesTemplateSdkService;

    /**
     * 查询分页列表
     *
     * @param pageable
     * @param paginationDto
     * @return
     */
    @ApiOperation(value = "查询分页列表")
    @GetMapping(value = {"/findByConditions"})
    public Result<Page<AuditFeeDiffDisposeDetailVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                                      AuditFeeDiffDisposeDetailDto paginationDto) {
        try {
            Page<AuditFeeDiffDisposeDetailVo> result = this.auditFeeDiffDisposeDetailVoService.findByConditions(pageable, paginationDto);
            return Result.ok(result);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 详情
     *
     * @param id
     * @return
     */
    @ApiOperation(value = "详情")
    @GetMapping(value = {"/findDetailById"})
    public Result<AuditFeeDiffDisposeDetailVo> findDetailById(@RequestParam("id") String id) {
        try {
            AuditFeeDiffDisposeDetailVo auditFeeDiffDisposeDetailVo = this.auditFeeDiffDisposeDetailVoService.findDetailById(id);
            return Result.ok(auditFeeDiffDisposeDetailVo);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 创建
     *
     * @param auditFeeDiffDisposeDetailVo
     * @return
     */
    @ApiOperation(value = "创建")
    @PostMapping(value = "")
    public Result<AuditFeeDiffDisposeDetailVo> create( @RequestBody AuditFeeDiffDisposeDetailVo auditFeeDiffDisposeDetailVo) {
        try {
            AuditFeeDiffDisposeDetailVo current = this.auditFeeDiffDisposeDetailVoService.create(auditFeeDiffDisposeDetailVo);
            return Result.ok(current);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 更新
     *
     * @param auditFeeDiffDisposeDetailVo
     * @return
     */
    @ApiOperation(value = "更新")
    @PatchMapping(value = "")
    public Result<AuditFeeDiffDisposeDetailVo> update(@RequestBody AuditFeeDiffDisposeDetailVo auditFeeDiffDisposeDetailVo) {
        try {
            AuditFeeDiffDisposeDetailVo current = this.auditFeeDiffDisposeDetailVoService.update(auditFeeDiffDisposeDetailVo);
            return Result.ok(current);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 启用
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "启用")
    @PatchMapping("/enable")
    public Result enable(@RequestBody List<String> ids) {
        try {
            this.auditFeeDiffDisposeDetailVoService.enableBatch(ids);
            return Result.ok("启用成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 禁用
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "禁用")
    @PatchMapping("/disable")
    public Result disable(@RequestBody List<String> ids) {
        try {
            this.auditFeeDiffDisposeDetailVoService.disableBatch(ids);
            return Result.ok("禁用成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 逻辑删除
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "逻辑删除")
    @DeleteMapping("/delete")
    public Result delete(@RequestParam("ids") List<String> ids) {
        try {
            this.auditFeeDiffDisposeDetailVoService.updateDelFlagByIds(ids);
            return Result.ok("删除成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 根据cacheKey获取预算信息
     *
     * @param cacheKey
     * @return
     */
    @ApiOperation(value = "根据cacheKey获取预算信息")
    @GetMapping("/findBudgetByCacheKey")
    public Result<List<AuditFeeDiffDisposeLedgerVo>> findBudgetByCacheKey(@RequestParam("cacheKey") String cacheKey) {
        try {
            List<AuditFeeDiffDisposeLedgerVo> auditFeeDiffDisposeBudgetVos = this.auditFeeDiffDisposeDetailVoService.findBudgetByCacheKey(cacheKey);
            return Result.ok(auditFeeDiffDisposeBudgetVos);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 获取活动方案可以选择的模板
     */
    @ApiOperation(value = "获取可以选择的模板")
    @PostMapping("findItemColumnConfigSelect")
    public Result<List<CommonSelectVo>> findItemColumnConfigSelect(@ApiParam(value = "dto")@RequestBody CommonSelectDto dto) {
        try {
            ActivitiesTemplateConfigDto configDto = new ActivitiesTemplateConfigDto();
            configDto.setType(ActivitiesTemplateConfigTypeEnum.DIFF_FEE_DISPOSE.getCode());
            List<CommonSelectVo> list = activitiesTemplateSdkService.findActivitiesTemplateConfigSelectList(dto, configDto);
            return Result.ok(list);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 获取单策略新增明细模板
     */
    @ApiOperation(value = "获取模板配置")
    @GetMapping("getItemColumnConfig")
    public Result<ActivitiesTemplateConfigVo> getItemColumnConfig(@ApiParam(value = "模板编码") @RequestParam(required = true) String configCode) {
        try {
            ActivitiesTemplateConfigVo configVo = activitiesTemplateSdkService.findByCode(configCode);
            return Result.ok(configVo);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

}
