package com.biz.crm.tpm.business.audit.fee.local.controller.dispose;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.dispose.AuditFeeDiffDisposeLedgerDto;
import com.biz.crm.tpm.business.audit.fee.sdk.service.dispose.AuditFeeDiffDisposeLedgerVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.dispose.AuditFeeDiffDisposeLedgerVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import java.util.List;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 核销差异费用处理预算汇总信息(AuditFeeDiffDisposeLedger)表控制层
 *
 * @author liuyifan
 * @date 2022-12-24 13:55:44
 */
@Slf4j
@Api(tags = "核销差异费用处理预算汇总信息")
@RestController
@RequestMapping(value = {"/v1/auditFeeDiffDisposeBudget/auditFeeDiffDisposeBudget"})
public class AuditFeeDiffDisposeLedgerController {

    @Autowired(required = false)
    private AuditFeeDiffDisposeLedgerVoService auditFeeDiffDisposeBudgetVoService;

    /**
     * 查询分页列表
     *
     * @param pageable      可分页
     * @param paginationDto 分页dto
     * @return {@link Result}<{@link Page}<{@link AuditFeeDiffDisposeLedgerVo}>>
     */
    @ApiOperation(value = "查询分页列表")
    @GetMapping(value = {"/findByConditions"})
    public Result<Page<AuditFeeDiffDisposeLedgerVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                                      AuditFeeDiffDisposeLedgerDto paginationDto) {
        try {
            Page<AuditFeeDiffDisposeLedgerVo> result = this.auditFeeDiffDisposeBudgetVoService.findByConditions(pageable, paginationDto);
            return Result.ok(result);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 详情
     *
     * @param id id
     * @return {@link Result}<{@link AuditFeeDiffDisposeLedgerVo}>
     */
    @ApiOperation(value = "详情")
    @GetMapping(value = {"/findDetailById"})
    public Result<AuditFeeDiffDisposeLedgerVo> findDetailById(@RequestParam("id") String id) {
        try {
            AuditFeeDiffDisposeLedgerVo auditFeeDiffDisposeBudgetVo = this.auditFeeDiffDisposeBudgetVoService.findDetailById(id);
            return Result.ok(auditFeeDiffDisposeBudgetVo);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 创建
     *
     * @param auditFeeDiffDisposeBudgetVo 差异费用处理预算vo
     * @return {@link Result}<{@link AuditFeeDiffDisposeLedgerVo}>
     */
    @ApiOperation(value = "创建")
    @PostMapping(value = "")
    public Result<AuditFeeDiffDisposeLedgerVo> create(@RequestBody AuditFeeDiffDisposeLedgerVo auditFeeDiffDisposeBudgetVo) {
        try {
            AuditFeeDiffDisposeLedgerVo current = this.auditFeeDiffDisposeBudgetVoService.create(auditFeeDiffDisposeBudgetVo);
            return Result.ok(current);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 更新
     *
     * @param auditFeeDiffDisposeBudgetVo 差异费用处理预算vo
     * @return {@link Result}<{@link AuditFeeDiffDisposeLedgerVo}>
     */
    @ApiOperation(value = "更新")
    @PatchMapping(value = "")
    public Result<AuditFeeDiffDisposeLedgerVo> update(@RequestBody AuditFeeDiffDisposeLedgerVo auditFeeDiffDisposeBudgetVo) {
        try {
            AuditFeeDiffDisposeLedgerVo current = this.auditFeeDiffDisposeBudgetVoService.update(auditFeeDiffDisposeBudgetVo);
            return Result.ok(current);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 启用
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "启用")
    @PatchMapping("/enable")
    public Result enable(@RequestBody List<String> ids) {
        try {
            this.auditFeeDiffDisposeBudgetVoService.enableBatch(ids);
            return Result.ok("启用成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 禁用
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "禁用")
    @PatchMapping("/disable")
    public Result disable(@RequestBody List<String> ids) {
        try {
            this.auditFeeDiffDisposeBudgetVoService.disableBatch(ids);
            return Result.ok("禁用成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 逻辑删除
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "逻辑删除")
    @DeleteMapping("/delete")
    public Result delete(@RequestParam("ids") List<String> ids) {
        try {
            this.auditFeeDiffDisposeBudgetVoService.updateDelFlagByIds(ids);
            return Result.ok("删除成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
