package com.biz.crm.tpm.business.audit.fee.local.controller.ledger;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.ledger.AuditFeeDiffLedgerConfirmDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.ledger.AuditFeeDiffLedgerDto;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.DiffLedgerDataSourceEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.service.ledger.AuditFeeDiffLedgerVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.ledger.AuditFeeDiffLedgerVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import java.util.List;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 核销差异费用台账(AuditFeeDiffLedger)表控制层
 *
 * @author makejava
 * @date 2022-12-19 11:02:14
 */
@Slf4j
@Api(tags = "核销差异费用台账")
@RestController
@RequestMapping(value = {"/v1/auditFeeDiffLedger/auditFeeDiffLedger"})
public class AuditFeeDiffLedgerController {

    @Autowired(required = false)
    private AuditFeeDiffLedgerVoService auditFeeDiffLedgerVoService;

    /**
     * 查询分页列表
     *
     * @param pageable
     * @param paginationDto
     * @return
     */
    @ApiOperation(value = "查询分页列表")
    @GetMapping(value = {"/findByConditions"})
    public Result<Page<AuditFeeDiffLedgerVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                               AuditFeeDiffLedgerDto paginationDto) {
        try {
            Page<AuditFeeDiffLedgerVo> result = this.auditFeeDiffLedgerVoService.findByConditions(pageable, paginationDto);
            return Result.ok(result);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 选择台帐列表
     *
     * @param pageable
     * @param paginationDto
     * @return
     */
    @ApiOperation(value = "选择台帐列表")
    @GetMapping(value = {"/selectByConditions"})
    public Result<Page<AuditFeeDiffLedgerVo>> selectByConditions(@PageableDefault(50) Pageable pageable,
                                                               AuditFeeDiffLedgerDto paginationDto) {
        try {
            Page<AuditFeeDiffLedgerVo> result = this.auditFeeDiffLedgerVoService.selectByConditions(pageable, paginationDto);
            return Result.ok(result);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 详情
     *
     * @param id
     * @return
     */
    @ApiOperation(value = "详情")
    @GetMapping(value = {"/findDetailById"})
    public Result<AuditFeeDiffLedgerVo> findDetailById(@RequestParam("id") String id) {
        try {
            AuditFeeDiffLedgerVo auditFeeDiffLedgerVo = this.auditFeeDiffLedgerVoService.findDetailById(id);
            return Result.ok(auditFeeDiffLedgerVo);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 创建
     *
     * @param auditFeeDiffLedgerVo
     * @return
     */
    @ApiOperation(value = "创建")
    @PostMapping(value = "")
    public Result<AuditFeeDiffLedgerVo> create(@RequestBody AuditFeeDiffLedgerDto dto) {
        try {
            dto.setDataSource(DiffLedgerDataSourceEnum.ADD_HAND.getCode());
            AuditFeeDiffLedgerVo current = this.auditFeeDiffLedgerVoService.create(dto);
            return Result.ok(current);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 更新
     *
     * @param auditFeeDiffLedgerVo
     * @return
     */
    @ApiOperation(value = "更新")
    @PatchMapping(value = "")
    public Result<AuditFeeDiffLedgerVo> update(@RequestBody AuditFeeDiffLedgerDto dto) {
        try {
            AuditFeeDiffLedgerVo current = this.auditFeeDiffLedgerVoService.update(dto);
            return Result.ok(current);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 启用
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "启用")
    @PatchMapping("/enable")
    public Result enable(@RequestBody List<String> ids) {
        try {
            this.auditFeeDiffLedgerVoService.enableBatch(ids);
            return Result.ok("启用成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 禁用
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "禁用")
    @PatchMapping("/disable")
    public Result disable(@RequestBody List<String> ids) {
        try {
            this.auditFeeDiffLedgerVoService.disableBatch(ids);
            return Result.ok("禁用成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 确认
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "确认")
    @PatchMapping("/confirm")
    public Result confirm(@RequestBody AuditFeeDiffLedgerConfirmDto dto) {
        try {
            this.auditFeeDiffLedgerVoService.confirm(dto);
            return Result.ok("操作成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 逻辑删除
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "逻辑删除")
    @DeleteMapping("/delete")
    public Result delete(@RequestParam("ids") List<String> ids) {
        try {
            this.auditFeeDiffLedgerVoService.updateDelFlagByIds(ids);
            return Result.ok("删除成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
