package com.biz.crm.tpm.business.audit.fee.local.controller.ledger;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.ledger.AuditFeeDiffLedgerDeductionDto;
import com.biz.crm.tpm.business.audit.fee.sdk.service.ledger.AuditFeeDiffLedgerDeductionVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.ledger.AuditFeeDiffLedgerDeductionVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import java.util.List;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 核销差异费用扣减明细(AuditFeeDiffLedgerDeduction)表控制层
 *
 * @author liuyifan
 * @date 2022-12-22 15:32:17
 */
@Slf4j
@Api(tags = "核销差异费用扣减明细")
@RestController
@RequestMapping(value = {"/v1/auditFeeDiffLedgerDeduction/auditFeeDiffLedgerDeduction"})
public class AuditFeeDiffLedgerDeductionController {

    @Autowired(required = false)
    private AuditFeeDiffLedgerDeductionVoService auditFeeDiffLedgerDeductionVoService;

    /**
     * 查询分页列表
     *
     * @param pageable
     * @param paginationDto
     * @return
     */
    @ApiOperation(value = "更加台账编码 分页查询列表")
    @GetMapping(value = {"/findByConditions"})
    public Result<Page<AuditFeeDiffLedgerDeductionVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                                        AuditFeeDiffLedgerDeductionDto paginationDto) {
        try {
            Validate.notBlank(paginationDto.getFeeDiffLedgerCode(),"差异费用台账编码不能为空！");
            Page<AuditFeeDiffLedgerDeductionVo> result = this.auditFeeDiffLedgerDeductionVoService.findByConditions(pageable, paginationDto);
            return Result.ok(result);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 详情
     *
     * @param id
     * @return
     */
    @ApiOperation(value = "详情")
    @GetMapping(value = {"/findDetailById"})
    public Result<AuditFeeDiffLedgerDeductionVo> findDetailById(@RequestParam("id") String id) {
        try {
            AuditFeeDiffLedgerDeductionVo auditFeeDiffLedgerDeductionVo = this.auditFeeDiffLedgerDeductionVoService.findDetailById(id);
            return Result.ok(auditFeeDiffLedgerDeductionVo);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 创建
     *
     * @param auditFeeDiffLedgerDeductionVo
     * @return
     */
    @ApiOperation(value = "创建")
    @PostMapping(value = "")
    public Result<AuditFeeDiffLedgerDeductionVo> create(@RequestBody AuditFeeDiffLedgerDeductionVo auditFeeDiffLedgerDeductionVo) {
        try {
            AuditFeeDiffLedgerDeductionVo current = this.auditFeeDiffLedgerDeductionVoService.create(auditFeeDiffLedgerDeductionVo);
            return Result.ok(current);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 更新
     *
     * @param auditFeeDiffLedgerDeductionVo
     * @return
     */
    @ApiOperation(value = "更新")
    @PatchMapping(value = "")
    public Result<AuditFeeDiffLedgerDeductionVo> update(@RequestBody AuditFeeDiffLedgerDeductionVo auditFeeDiffLedgerDeductionVo) {
        try {
            AuditFeeDiffLedgerDeductionVo current = this.auditFeeDiffLedgerDeductionVoService.update(auditFeeDiffLedgerDeductionVo);
            return Result.ok(current);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 启用
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "启用")
    @PatchMapping("/enable")
    public Result enable(@RequestBody List<String> ids) {
        try {
            this.auditFeeDiffLedgerDeductionVoService.enableBatch(ids);
            return Result.ok("启用成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 禁用
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "禁用")
    @PatchMapping("/disable")
    public Result disable(@RequestBody List<String> ids) {
        try {
            this.auditFeeDiffLedgerDeductionVoService.disableBatch(ids);
            return Result.ok("禁用成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 逻辑删除
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "逻辑删除")
    @DeleteMapping("/delete")
    public Result delete(@RequestParam("ids") List<String> ids) {
        try {
            this.auditFeeDiffLedgerDeductionVoService.updateDelFlagByIds(ids);
            return Result.ok("删除成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
