package com.biz.crm.tpm.business.audit.fee.local.controller.ledger;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.common.page.cache.controller.MnPageCacheController;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.dispose.AuditFeeDiffDisposeDetailDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.dispose.AuditFeeDiffDisposeDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.ledger.AuditFeeDiffLedgerPlanDto;
import com.biz.crm.tpm.business.audit.fee.sdk.service.ledger.AuditFeeDiffLedgerPlanVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.dispose.AuditFeeDiffDisposeDetailVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.ledger.AuditFeeDiffLedgerPlanVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import java.util.List;

import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 核销差异费用台账计划明细(AuditFeeDiffLedgerPlan)表控制层
 *
 * @author liuyifan
 * @date 2022-12-22 15:30:37
 */
@Slf4j
@Api(tags = "核销差异费用台账计划明细")
@RestController
@RequestMapping(value = {"/v1/auditFeeDiffLedgerPlan/auditFeeDiffLedgerPlan"})
public class AuditFeeDiffLedgerPlanController extends MnPageCacheController<AuditFeeDiffLedgerPlanVo, AuditFeeDiffLedgerPlanDto>  {

    @Autowired(required = false)
    private AuditFeeDiffLedgerPlanVoService auditFeeDiffLedgerPlanVoService;

    /**
     * 查询分页列表
     *
     * @param pageable
     * @param paginationDto
     * @return
     */
    @ApiOperation(value = "查询分页列表")
    @GetMapping(value = {"/findByConditions"})
    public Result<Page<AuditFeeDiffLedgerPlanVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                                   AuditFeeDiffLedgerPlanDto paginationDto) {
        try {
            Page<AuditFeeDiffLedgerPlanVo> result = this.auditFeeDiffLedgerPlanVoService.findByConditions(pageable, paginationDto);
            return Result.ok(result);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 详情
     *
     * @param id
     * @return
     */
    @ApiOperation(value = "详情")
    @GetMapping(value = {"/findDetailById"})
    public Result<AuditFeeDiffLedgerPlanVo> findDetailById(@RequestParam("id") String id) {
        try {
            AuditFeeDiffLedgerPlanVo auditFeeDiffLedgerPlanVo = this.auditFeeDiffLedgerPlanVoService.findDetailById(id);
            return Result.ok(auditFeeDiffLedgerPlanVo);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 创建
     *
     * @param cacheKey 缓存key
     * @return
     */
    @ApiOperation(value = "提交")
    @PostMapping(value = "")
    public Result create(@RequestParam(value = "cacheKey") String cacheKey, @RequestBody AuditFeeDiffLedgerPlanDto dto) {
        try {
            dto.setCacheKey(cacheKey);
            this.auditFeeDiffLedgerPlanVoService.create(dto);
            return Result.ok("操作成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 更新
     *
     * @param auditFeeDiffLedgerPlanVo
     * @return
     */
    @ApiOperation(value = "更新")
    @PatchMapping(value = "")
    public Result<AuditFeeDiffLedgerPlanVo> update(@RequestBody AuditFeeDiffLedgerPlanVo auditFeeDiffLedgerPlanVo) {
        try {
            AuditFeeDiffLedgerPlanVo current = this.auditFeeDiffLedgerPlanVoService.update(auditFeeDiffLedgerPlanVo);
            return Result.ok(current);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 启用
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "启用")
    @PatchMapping("/enable")
    public Result enable(@RequestBody List<String> ids) {
        try {
            this.auditFeeDiffLedgerPlanVoService.enableBatch(ids);
            return Result.ok("启用成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 禁用
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "禁用")
    @PatchMapping("/disable")
    public Result disable(@RequestBody List<String> ids) {
        try {
            this.auditFeeDiffLedgerPlanVoService.disableBatch(ids);
            return Result.ok("禁用成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 逻辑删除
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "逻辑删除")
    @DeleteMapping("/delete")
    public Result delete(@RequestParam("ids") List<String> ids) {
        try {
            this.auditFeeDiffLedgerPlanVoService.updateDelFlagByIds(ids);
            return Result.ok("删除成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
