package com.biz.crm.tpm.business.audit.fee.local.controller.prediction;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.tpm.business.audit.fee.local.service.perdiction.AuditFeePredictionService;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.prediction.AuditFeePredictionDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.settlement.check.AuditFeeSettlementCheckDetailPlanDto;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.prediction.AuditFeePredictionVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.settlement.check.AuditFeeSettlementCheckDetailPlanVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @Author: zhouyang
 * @Date: 2023/9/23
 */
@Slf4j
@Api(tags = "扣费预测管理主表")
@RestController
@RequestMapping(value = {"/v1/AuditFeePrediction"})
public class AuditFeePredictionController {

    @Autowired
    private AuditFeePredictionService auditFeePredictionService;

    @Autowired
    private LoginUserService loginUserService;

    /**
     * 查询分页列表
     *
     * @param pageable      可分页
     * @param dto 分页dto
     */
    @ApiOperation(value = "查询分页列表")
    @GetMapping(value = {"/findByConditions"})
    public Result<Page<AuditFeePredictionVo>> findByConditions(@PageableDefault(50) Pageable pageable, AuditFeePredictionDto dto) {
        try {
            Page<AuditFeePredictionVo> result = this.auditFeePredictionService.findByConditions(pageable, dto);
            return Result.ok(result);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 批量创建
     *
     * @param dtos
     * @return
     */
    @ApiOperation(value = "批量创建")
    @PostMapping(value = "createBatch")
    public Result<?> createBatch(@RequestBody List<AuditFeePredictionDto> dtos) {
        try {
            this.auditFeePredictionService.createBatch(dtos);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 根据ids更新数据
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "根据ids更新数据")
    @PostMapping(value = "autoUpdateByIds")
    public Result<?> autoUpdateByIds(@RequestBody List<String> ids) {
        try {
            this.auditFeePredictionService.autoUpdateByIds(ids);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 根据ids删除数据
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "根据ids更新数据")
    @PostMapping(value = "deleteByIds")
    public Result<?> deleteByIds(@RequestBody List<String> ids) {
        try {
            this.auditFeePredictionService.deleteByIds(ids);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 测试定时任务自动同步数据
     *
     * @return
     */
    @ApiOperation(value = "测试定时任务自动同步数据")
    @PostMapping(value = "autoJobSync")
    public Result<?> autoJobSync(@RequestBody AuditFeePredictionDto dto) {
        try {
            this.auditFeePredictionService.autoJobAsync(dto,loginUserService.getLoginUser());
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

}
