package com.biz.crm.tpm.business.audit.fee.local.controller.settlement.check;


import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.audit.fee.local.service.settlement.check.AuditFeeSettlementCheckService;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.settlement.check.AuditFeeSettlementCheckDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.settlement.check.AuditFeeSettlementCheckFindFeeDto;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.settlement.check.AuditFeeSettlementCheckVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * @Author: zhouyang
 * @Date: 2023/9/23
 */
@Slf4j
@Api(tags = "结算核对管理主表")
@RestController
@RequestMapping(value = {"/v1/auditFeeSettlementCheck"})
public class AuditFeeSettlementCheckController {

    @Autowired
    private AuditFeeSettlementCheckService auditFeeSettlementCheckService;

    /**
     * 查询
     * @param id
     * @return
     */
    @ApiOperation(value = "查询")
    @PostMapping(value = "findById")
    public Result<AuditFeeSettlementCheckVo> findById(@RequestParam("id") String id) {
        try {
            AuditFeeSettlementCheckVo vo = this.auditFeeSettlementCheckService.findById(id);
            return Result.ok(vo);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 取消匹配结果
     * @param id
     * @return
     */
    @ApiOperation(value = "取消匹配结果")
    @PatchMapping(value = "cancelMatch")
    public Result<?> cancelMatch(@RequestBody String id) {
        try {
            this.auditFeeSettlementCheckService.cancelMatch(id);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 手工调整匹配结果
     * @param ids
     * @return
     */
    @ApiOperation(value = "手工调整匹配结果")
    @PatchMapping(value = "handleChangeMatch")
    public Result<?> handleChangeMatch(@RequestBody List<String> ids) {
        try {
            this.auditFeeSettlementCheckService.handleChangeMatch(ids);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 重新匹配结果
     * @param id
     * @return
     */
    @ApiOperation(value = "重新匹配结果")
    @PostMapping(value = "matchAgain")
    public Result<?> matchAgain(@RequestBody String id) {
        try {
            this.auditFeeSettlementCheckService.matchAgain(id);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 提交保存/确认
     * @param dto
     * @return
     */
    @ApiOperation(value = "提交保存")
    @PostMapping(value = "update")
    public Result<?> update(@RequestBody AuditFeeSettlementCheckDto dto) {
        try {
            this.auditFeeSettlementCheckService.update(dto);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 差异保存
     * @param dto
     * @return
     */
    @ApiOperation(value = "差异保存")
    @PostMapping(value = "diffSave")
    public Result<?> diffSave(@RequestBody AuditFeeSettlementCheckDto dto) {
        try {
            this.auditFeeSettlementCheckService.diffSave(dto);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 手动计算
     * @param dto
     * @return
     */
    @ApiOperation(value = "手动计算")
    @PatchMapping(value = "compute")
    public Result<AuditFeeSettlementCheckDto> compute(@RequestBody AuditFeeSettlementCheckDto dto) {
        try {
            return Result.ok(this.auditFeeSettlementCheckService.compute(dto));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 抽取费用数据
     * @param dto
     * @return
     */
    @ApiOperation(value = "抽取费用数据")
    @PostMapping(value = "findFeeInfo")
    public Result<?> findFeeInfo(@RequestBody AuditFeeSettlementCheckFindFeeDto dto) {
        try {
            this.auditFeeSettlementCheckService.findFeeInfo(dto);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 删除
     * @param ids
     * @return
     */
    @ApiOperation(value = "删除")
    @DeleteMapping(value = "deleteByIds")
    public Result<?> deleteByIds(@RequestParam("ids") String ids) {
        try {
            this.auditFeeSettlementCheckService.deleteByIds(ids);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 更新分摊金额
     * @param dto
     * @return
     */
    @ApiOperation(value = "更新分摊金额")
    @PostMapping(value = "updateApportionAmount")
    public Result<?> updateApportionAmountByCode(@RequestBody AuditFeeSettlementCheckDto dto) {
        try {
            this.auditFeeSettlementCheckService.updateApportionAmount(dto);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 测试定时任务
     * @return
     */
    @ApiOperation(value = "测试定时任务")
    @DeleteMapping(value = "autoJobUpdate")
    public Result<?> autoJobUpdate() {
        try {
            this.auditFeeSettlementCheckService.autoJobUpdate();
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

}
