package com.biz.crm.tpm.business.audit.fee.local.controller.settlement.check;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.common.page.cache.controller.MnPageCacheController;
import com.biz.crm.tpm.business.audit.fee.local.service.settlement.check.AuditFeeSettlementCheckDetailPlanService;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.settlement.check.AuditFeeSettlementCheckDetailPlanDto;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.settlement.check.AuditFeeSettlementCheckDetailPlanVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * @Author: zhouyang
 * @Date: 2023/9/23
 */
@Slf4j
@Api(tags = "结算核对管理-细案")
@RestController
@RequestMapping(value = {"/v1/auditFeeSettlementCheck/detailPlan"})
public class AuditFeeSettlementCheckDetailPlanController extends MnPageCacheController<AuditFeeSettlementCheckDetailPlanVo,AuditFeeSettlementCheckDetailPlanDto> {

    @Autowired
    private AuditFeeSettlementCheckDetailPlanService auditFeeSettlementCheckDetailPlanService;

    /**
     * 查询分页列表
     *
     * @param pageable      可分页
     * @param dto 分页dto
     * @return {@link Result}<{@link Page}<{@link AuditFeeSettlementCheckDetailPlanVo}>>
     */
    @ApiOperation(value = "查询分页列表")
    @GetMapping(value = {"/findByConditions"})
    public Result<Page<AuditFeeSettlementCheckDetailPlanVo>> findByConditions(@PageableDefault(50) Pageable pageable,AuditFeeSettlementCheckDetailPlanDto dto) {
        try {
            Page<AuditFeeSettlementCheckDetailPlanVo> result = this.auditFeeSettlementCheckDetailPlanService.findByConditions(pageable, dto);
            return Result.ok(result);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 根据id查询
     * @param id
     * @return
     */
    @ApiOperation(value = "根据id查询")
    @PostMapping(value = "/findById")
    public Result<AuditFeeSettlementCheckDetailPlanVo> findById(@RequestParam("id") String id) {
        try {
            AuditFeeSettlementCheckDetailPlanVo vo = this.auditFeeSettlementCheckDetailPlanService.findById(id);
            return Result.ok(vo);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 批量删除
     * @param ids
     * @return
     */
    @ApiOperation(value = "批量删除")
    @DeleteMapping(value = "/deleteBatch")
    public Result<?> deleteBatch(@RequestParam("ids") List<String> ids) {
        try {
            this.auditFeeSettlementCheckDetailPlanService.deleteBatch(ids);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 查询扣费预测细案细类分页列表
     *
     * @param pageable
     * @param paginationDto
     * @return
     */
    @ApiOperation(value = "查询扣费预测细案细类分页列表")
    @GetMapping(value = {"/findDetailPlanByConditions"})
    public Result<Page<AuditFeeSettlementCheckDetailPlanVo>> findDetailPlanByConditions(@PageableDefault(50) Pageable pageable, AuditFeeSettlementCheckDetailPlanDto paginationDto) {
        try {
            Page<AuditFeeSettlementCheckDetailPlanVo> result = this.auditFeeSettlementCheckDetailPlanService.findDetailPlanByConditions(pageable, paginationDto);
            return Result.ok(result);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

}
