package com.biz.crm.tpm.business.audit.fee.local.controller.settlement.check;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.common.page.cache.controller.MnPageCacheController;
import com.biz.crm.tpm.business.audit.fee.local.service.settlement.check.AuditFeeSettlementCheckFeeService;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.settlement.check.AuditFeeSettlementCheckFeeDto;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.settlement.check.AuditFeeSettlementCheckFeeVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * @Author: zhouyang
 * @Date: 2023/9/23
 */
@Slf4j
@Api(tags = "结算核对管理-费用单")
@RestController
@RequestMapping(value = {"/v1/auditFeeSettlementCheck/fee"})
public class AuditFeeSettlementCheckFeeController extends MnPageCacheController<AuditFeeSettlementCheckFeeVo,AuditFeeSettlementCheckFeeDto> {

    @Autowired
    private AuditFeeSettlementCheckFeeService auditFeeSettlementCheckFeeService;

    /**
     * 查询分页列表
     *
     * @param pageable      可分页
     * @param dto 分页dto
     * @return {@link Result}<{@link Page}<{@link AuditFeeSettlementCheckFeeVo}>>
     */
    @ApiOperation(value = "查询分页列表")
    @GetMapping(value = {"/findByConditions"})
    public Result<Page<AuditFeeSettlementCheckFeeVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                                       AuditFeeSettlementCheckFeeDto dto) {
        try {
            Page<AuditFeeSettlementCheckFeeVo> result = this.auditFeeSettlementCheckFeeService.findByConditions(pageable, dto);
            return Result.ok(result);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 根据id查询
     * @param id
     * @return
     */
    @ApiOperation(value = "根据id查询")
    @PostMapping(value = "/findById")
    public Result<AuditFeeSettlementCheckFeeVo> findById(@RequestParam("id") String id) {
        try {
            AuditFeeSettlementCheckFeeVo vo = this.auditFeeSettlementCheckFeeService.findById(id);
            return Result.ok(vo);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 批量删除
     * @param ids
     * @return
     */
    @ApiOperation(value = "批量删除")
    @DeleteMapping(value = "/deleteBatch")
    public Result<?> deleteBatch(@RequestParam("ids") List<String> ids) {
        try {
            this.auditFeeSettlementCheckFeeService.deleteBatch(ids);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }



}
