package com.biz.crm.tpm.business.audit.fee.local.controller.settlement.check;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.common.page.cache.controller.MnPageCacheController;
import com.biz.crm.tpm.business.audit.fee.local.service.settlement.check.AuditFeeSettlementCheckSettlementService;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.settlement.check.AuditFeeSettlementCheckSettlementDto;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.settlement.check.AuditFeeSettlementCheckSettlementVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * @Author: zhouyang
 * @Date: 2023/9/23
 */
@Slf4j
@Api(tags = "结算核对管理-结算单")
@RestController
@RequestMapping(value = {"/v1/auditFeeSettlementCheck/settlement"})
public class AuditFeeSettlementCheckSettlementController extends MnPageCacheController<AuditFeeSettlementCheckSettlementVo,AuditFeeSettlementCheckSettlementDto> {

    @Autowired
    private AuditFeeSettlementCheckSettlementService auditFeeSettlementCheckSettlementService;

    /**
     * 查询分页列表
     *
     * @param pageable      可分页
     * @param dto 分页dto
     * @return {@link Result}<{@link Page}<{@link AuditFeeSettlementCheckSettlementVo}>>
     */
    @ApiOperation(value = "查询分页列表")
    @GetMapping(value = {"/findByConditions"})
    public Result<Page<AuditFeeSettlementCheckSettlementVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                                              AuditFeeSettlementCheckSettlementDto dto) {
        try {
            Page<AuditFeeSettlementCheckSettlementVo> result = this.auditFeeSettlementCheckSettlementService.findByConditions(pageable, dto);
            return Result.ok(result);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 根据id查询
     * @param id
     * @return
     */
    @ApiOperation(value = "根据id查询")
    @GetMapping(value = "/findById")
    public Result<AuditFeeSettlementCheckSettlementVo> findById(@RequestParam("id") String id) {
        try {
            AuditFeeSettlementCheckSettlementVo vo = this.auditFeeSettlementCheckSettlementService.findById(id);
            return Result.ok(vo);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 批量删除
     * @param ids
     * @return
     */
    @ApiOperation(value = "批量删除")
    @DeleteMapping(value = "/deleteBatch")
    public Result<?> deleteBatch(@RequestParam("ids") List<String> ids) {
        try {
            this.auditFeeSettlementCheckSettlementService.deleteBatch(ids);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }



}
