package com.biz.crm.tpm.business.audit.fee.local.controller.track;

import cn.hutool.core.lang.Snowflake;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mn.common.base.dto.CommonSelectDto;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import com.biz.crm.tpm.business.activities.template.config.sdk.dto.ActivitiesTemplateConfigDto;
import com.biz.crm.tpm.business.audit.fee.local.service.imports.AuditFeeDiffTrackDetailImportProcess;
import com.biz.crm.tpm.business.audit.fee.local.service.imports.vo.AuditFeeDiffTrackDetailImportVo;
import com.biz.crm.tpm.business.audit.fee.sdk.constants.AuditFeeDiffTrackConstants;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.track.AuditFeeDiffTrackApproveSubmitDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.track.AuditFeeDiffTrackDto;
import com.biz.crm.tpm.business.audit.fee.sdk.service.ledger.AuditFeeDiffLedgerLockService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.track.AuditFeeDiffTrackVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.track.AuditFeeDiffTrackSummaryVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.track.AuditFeeDiffTrackVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 差异费用追踪控制层
 *
 * @author makejava
 * @date 2022-11-14 16:56:09
 */
@Slf4j
@Api(tags = "差异费用追踪控制层")
@RestController
@RequestMapping(value = {"/v1/auditFeeTrack/auditFeeTrack"})
public class AuditFeeDiffTrackController {

    @Resource
    private AuditFeeDiffTrackVoService auditFeeDiffTrackVoService;
    @Autowired(required = false)
    private RedisLockService redisLockService;
    @Autowired(required = false)
    private RedisService redisService;
    @Autowired(required = false)
    private AuditFeeDiffLedgerLockService auditFeeDiffLedgerLockService;
    @Autowired(required = false)
    private AuditFeeDiffTrackDetailImportProcess auditFeeDiffTrackDetailImportProcess;

    /**
     * 根据条件查询
     *
     * @param pageable      可分页
     * @param paginationDto 分页dto
     * @return {@link Result}<{@link Page}<{@link AuditFeeDiffTrackVo}>>
     */
    @ApiOperation(value = "查询分页列表")
    @GetMapping(value = {"/findByConditions"})
    public Result<Page<AuditFeeDiffTrackVo>> findByConditions(@PageableDefault(50) Pageable pageable, AuditFeeDiffTrackDto paginationDto) {
        try {
            Page<AuditFeeDiffTrackVo> result = this.auditFeeDiffTrackVoService.findByConditions(pageable, paginationDto);
            return Result.ok(result);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 详情
     *
     * @param id id
     * @return {@link Result}<{@link AuditFeeDiffTrackVo}>
     */
    @ApiOperation(value = "详情")
    @GetMapping(value = {"/findDetailById"})
    public Result<AuditFeeDiffTrackVo> findDetailById(@RequestParam("id") String id) {
        try {
            AuditFeeDiffTrackVo AuditFeeDiffTrackVo = this.auditFeeDiffTrackVoService.findById(id);
            return Result.ok(AuditFeeDiffTrackVo);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "详情-流程表单")
    @GetMapping(value = {"/findDetailByProcessNo"})
    public Result<AuditFeeDiffTrackVo> findDetailByProcessNo(@RequestParam("processNo") String processNo) {
        try {
            AuditFeeDiffTrackVo AuditFeeDiffTrackVo = this.auditFeeDiffTrackVoService.findDetailByProcessNo(processNo);
            return Result.ok(AuditFeeDiffTrackVo);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping(value = {"/create"})
    public Result<?> create(@RequestBody AuditFeeDiffTrackDto dto) {
        try {
            this.auditFeeDiffTrackVoService.create(dto);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 编辑
     */
    @ApiOperation(value = "编辑")
    @PatchMapping(value = {"/edit"})
    public Result<?> edit(@RequestBody AuditFeeDiffTrackDto dto) {
        try {
            this.auditFeeDiffTrackVoService.edit(dto);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PatchMapping(value = {"/delete"})
    public Result<?> delete(@RequestParam("ids") List<String> ids) {
        try {
            this.auditFeeDiffTrackVoService.delete(ids);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 获取活动方案可以选择的模板
     */
    @ApiOperation(value = "获取活动方案可以选择的模板")
    @PostMapping("findItemColumnConfigSelect")
    public Result<List<CommonSelectVo>> findItemColumnConfigSelect(@ApiParam(value = "模板编码") ActivitiesTemplateConfigDto configDto, @ApiParam(value = "活动类型dto")@RequestBody CommonSelectDto dto) {
        try {
            return Result.ok(auditFeeDiffTrackVoService.findActivitiesTemplateConfigSelectList(configDto, dto));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 提交流程,多选批量提交
     */
    @ApiOperation(value = "提交流程,多选批量提交")
    @PostMapping(value = "submitApproval")
    public Result submitApproval(@ApiParam(value = "提交流程,多选批量提交")@RequestBody AuditFeeDiffTrackApproveSubmitDto dto){

        List<String> ids = dto.getIds();
        boolean lockSuccess = false;
        String operateId = new Snowflake().nextIdStr();
        try {
            if (CollectionUtils.isEmpty(ids)){
                throw new RuntimeException("请选择数据！");
            }
            //提交审批前加锁一个小时
            lockSuccess = redisLockService.batchLock(AuditFeeDiffTrackConstants.LOCK_AUDIT_FEE_DIFF_TRACK_APPROVE, ids, TimeUnit.HOURS, 1);
            if (!lockSuccess) {
                throw new RuntimeException("数据处理中，请稍后");
            }
            dto.setOperateId(operateId);
            this.auditFeeDiffTrackVoService.submitApproval(dto.getIds(),dto);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        } finally {
            if (lockSuccess){
                redisLockService.batchUnLock(AuditFeeDiffTrackConstants.LOCK_AUDIT_FEE_DIFF_TRACK_APPROVE, ids);
            }
            String key = String.format(AuditFeeDiffTrackConstants.AUDIT_FEE_DIFF_TRACK_OPERATE,operateId);
            if(this.redisService.hasKey(key)){
                this.auditFeeDiffLedgerLockService.unlock((List<String>) this.redisService.get(key));
                this.redisService.del(key);
            }
        }
    }

    /**
     * 关闭活动细案明细
     * @param ids 活动细案明细id集合
     */
    @ApiOperation(value = "关闭活动细案明细")
    @PostMapping("closeItem")
    public Result<?> closeItem(@ApiParam(name = "ids", value = "要删除的数据") @RequestBody List<String> ids) {
        boolean lockSuccess = false;
        String operateId = new Snowflake().nextIdStr();
        try {
            //锁1小时
            lockSuccess = redisLockService.batchLock(AuditFeeDiffTrackConstants.LOCK_AUDIT_FEE_DIFF_TRACK_CLOSE, ids, TimeUnit.HOURS, 1);
            Assert.isTrue(lockSuccess, "其他人正在操作数据,加锁失败,请稍后重试!");
            this.auditFeeDiffTrackVoService.close(ids,operateId);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        } finally {
            if (lockSuccess){
                redisLockService.batchUnLock(AuditFeeDiffTrackConstants.LOCK_AUDIT_FEE_DIFF_TRACK_CLOSE, ids);
            }
            String key = String.format(AuditFeeDiffTrackConstants.AUDIT_FEE_DIFF_TRACK_OPERATE,operateId);
            if(this.redisService.hasKey(key)){
                this.auditFeeDiffLedgerLockService.unlock((List<String>) this.redisService.get(key));
                this.redisService.del(key);
            }
        }
    }

    @ApiOperation(value = "汇总差异费用信息")
    @PostMapping("collectDiffAmount")
    public Result<List<AuditFeeDiffTrackSummaryVo>> collectDiffAmount(@ApiParam(value = "id+模板编码+缓存key") @RequestBody AuditFeeDiffTrackDto dto) {
        try {
            List<AuditFeeDiffTrackSummaryVo> auditFeeDiffTrackSummaryVo= this.auditFeeDiffTrackVoService.collectDiffAmount(dto);
            return Result.ok(auditFeeDiffTrackSummaryVo);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "申请金额汇总")
    @PostMapping("collectFeeAmount")
    public Result<?> collectFeeAmount(@ApiParam(value = "缓存key 只要planCode") @RequestBody AuditFeeDiffTrackDto dto) {
        try {
            BigDecimal salesAmount = this.auditFeeDiffTrackVoService.collectFeeAmount(dto);
            return Result.ok(salesAmount);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "testImport")
    @PostMapping("testImport")
    public Result<?> testImport(@RequestBody LinkedHashMap<Integer, AuditFeeDiffTrackDetailImportVo> data, Map<String, Object> params) {
        try {
            return Result.ok(auditFeeDiffTrackDetailImportProcess.execute(data, null, params));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "手动推送牛人管家，推送审批通过，但是没有牛人管家推送成功标记的明细数据")
    @PostMapping("pushCowManagerManual")
    public Result<?> pushCowManagerManual() {
        try {
            auditFeeDiffTrackVoService.pushCowManagerManual();
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
