package com.biz.crm.tpm.business.audit.fee.local.controller.track;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.common.page.cache.controller.MnPageCacheController;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.track.AuditFeeDiffTrackDetailDto;
import com.biz.crm.tpm.business.audit.fee.sdk.service.track.AuditFeeDiffTrackDetailVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.track.AuditFeeDiffTrackDetailVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

/**
 * 差异费用追踪细案控制层
 *
 * @author makejava
 * @date 2022-11-14 16:56:09
 */
@Slf4j
@Api(tags = "差异费用追踪细案控制层")
@RestController
@RequestMapping(value = {"/v1/auditFeeTrackDetail/auditFeeTrackDetail"})
public class AuditFeeDiffTrackDetailController extends MnPageCacheController<AuditFeeDiffTrackDetailVo, AuditFeeDiffTrackDetailDto> {

    @Resource
    private AuditFeeDiffTrackDetailVoService auditFeeDiffTrackDetailVoService;

    /**
     * 根据条件查询
     *
     * @param pageable      可分页
     * @param paginationDto 分页dto
     * @return {@link Result}<{@link Page}<{@link AuditFeeDiffTrackDetailVo}>>
     */
    @ApiOperation(value = "查询分页列表")
    @GetMapping(value = {"/findByConditions"})
    public Result<Page<AuditFeeDiffTrackDetailVo>> findByConditions(@PageableDefault(50) Pageable pageable, AuditFeeDiffTrackDetailDto paginationDto) {
        try {
            Page<AuditFeeDiffTrackDetailVo> result = this.auditFeeDiffTrackDetailVoService.findByConditions(pageable, paginationDto);
            return Result.ok(result);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation("差异费用结案")
    @GetMapping("auditFindByConditions")
    public Result<Page<AuditFeeDiffTrackDetailVo>> auditFindByConditions(@PageableDefault(50) Pageable pageable, AuditFeeDiffTrackDetailDto paginationDto){
        try {
            Page<AuditFeeDiffTrackDetailVo> result = this.auditFeeDiffTrackDetailVoService.auditFindByConditions(pageable, paginationDto);
            return Result.ok(result);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 详情
     *
     * @param id id
     * @return {@link Result}<{@link AuditFeeDiffTrackDetailVo}>
     */
    @ApiOperation(value = "详情")
    @GetMapping(value = {"/findDetailById"})
    public Result<AuditFeeDiffTrackDetailVo> findDetailById(@RequestParam("id") String id) {
        try {
            AuditFeeDiffTrackDetailVo AuditFeeDiffTrackDetailVo = this.auditFeeDiffTrackDetailVoService.findDetailById(id);
            return Result.ok(AuditFeeDiffTrackDetailVo);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 批量关闭追踪明细
     */
    @ApiOperation(value = "批量关闭追踪明细")
    @PatchMapping(value = {"/closeBatch"})
    public Result<?> closeBatch(@RequestBody List<String> ids) {
        try {
            this.auditFeeDiffTrackDetailVoService.closeBatch(ids);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
