package com.biz.crm.tpm.business.audit.fee.local.entity.check;


import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author LiuYiFan
 */
@ApiModel(value = "Audit", description = "核销费用核对主表")
@TableName("tpm_audit_fee_check")
@Getter
@Setter
@Entity(name = "tpm_audit_fee_check")
@org.hibernate.annotations.Table(appliesTo = "tpm_audit_fee_check", comment = "核销费用核对主表")
@Table(name = "tpm_audit_fee_check",
    indexes = {@Index(name = "tpm_audit_fee_check_index1", columnList = "match_code,tenant_code,del_flag,order_date"),
        @Index(name = "tpm_audit_fee_check_index2", columnList = "business_format_code,business_unit_code")})
public class AuditFeeCheck extends TenantFlagOpEntity {

    @ApiModelProperty(name = "扣费匹配单号", notes = "扣费匹配单号")
    @Column(name = "match_code",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '扣费匹配单号'")
    private String matchCode;

    @ApiModelProperty(name = "实际扣费年月", notes = "实际扣费年月")
    @DateTimeFormat(pattern = "yyyy-MM")
    @Column(name = "actual_year_month",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '实际扣费年月(yyyy-MM)'")
    private String actualYearMonth;

    @ApiModelProperty(name = "对账年月", notes = "对账年月")
    @Column(name = "order_year_month_str",  length = 7, columnDefinition = "VARCHAR(7) COMMENT '对账年月(yyyy-MM)'")
    private String orderYearMonthStr;

    @ApiModelProperty(name = "对账年月", notes = "对账年月")
    @DateTimeFormat(pattern = "yyyy-MM")
    @Column(name = "order_year_month",  length = 32, columnDefinition = "datetime COMMENT '对账年月(yyyy-MM)'")
    private Date orderYearMonth;

    @ApiModelProperty(name = "对账日期", notes = "对账日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "order_date",  columnDefinition = "datetime COMMENT '对账年月(yyyy-MM-dd)'")
    private Date orderDate;

    @ApiModelProperty(name = "匹配模板名称", notes = "匹配模板名称")
    @Column(name = "match_template_name",  length = 32, columnDefinition = "VARCHAR(128) COMMENT '匹配模板名称'")
    private String matchTemplateName;

    @ApiModelProperty(name = "匹配模板编码", notes = "匹配模板编码")
    @Column(name = "match_template_code",  length = 64, columnDefinition = "VARCHAR(64) COMMENT '匹配模板编码'")
    private String matchTemplateCode;

    @ApiModelProperty(name = "模板类型", notes = "模板类型")
    @Column(name = "match_template_type",  length = 64, columnDefinition = "VARCHAR(64) COMMENT '模板类型'")
    private String matchTemplateType;

    @ApiModelProperty(name = "是否确认", notes = "是否确认")
    @Column(name = "is_confirm",  length = 8, columnDefinition = "VARCHAR(8) COMMENT '是否确认(Y,N)'")
    private String isConfirm;

    @ApiModelProperty(name = "匹配状态", notes = "匹配状态")
    @Column(name = "match_status",  length = 32, columnDefinition = "VARCHAR(32) default 'wait_match' COMMENT '匹配状态'")
    private String matchStatus;

    @ApiModelProperty(name = "匹配结果", notes = "匹配结果")
    @Column(name = "match_result",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '匹配结果'")
    private String matchResult;

    @ApiModelProperty(name = "terminalCode", notes = "门店编码", value = "门店编码")
    @Column(name = "terminal_code",  length = 64, columnDefinition = "VARCHAR(64) COMMENT '门店编码'")
    private String terminalCode;

    @ApiModelProperty(name = "terminalName", notes = "门店名称", value = "门店名称")
    @Column(name = "terminal_name",  length = 64, columnDefinition = "VARCHAR(64) COMMENT '门店名称'")
    private String terminalName;


    @ApiModelProperty(name = "productCode", notes = "商品编码", value = "商品编码")
    @Column(name = "product_code",  length = 64, columnDefinition = "VARCHAR(64) COMMENT '商品编码'")
    private String productCode;

    @ApiModelProperty(name = "productName", notes = "商品名称", value = "商品名称")
    @Column(name = "product_name",  length = 64, columnDefinition = "VARCHAR(64) COMMENT '商品名称'")
    private String productName;

    @ApiModelProperty("省编码(门店管理-省)")
    @Column(name = "province_code", length = 255, columnDefinition = "VARCHAR(255) COMMENT '省编码(门店管理-省)'")
    private String provinceCode;

    @ApiModelProperty("省名称(门店管理-省)")
    @Column(name = "province_name", length = 255, columnDefinition = "VARCHAR(255) COMMENT '省名称(门店管理-省)'")
    private String provinceName;

    @ApiModelProperty(name = "cost_deduction_amount", notes = "费用单扣费含税金额", value = "费用单扣费含税金额")
    @Column(name = "cost_deduction_amount",   columnDefinition = "decimal(24,6) COMMENT '费用单扣费含税金额'")
    private BigDecimal costDeductionAmount;

    @ApiModelProperty(name = "activity_pre_audit_amount", notes = "细案待核销金额", value = "细案待核销金额")
    @Column(name = "activity_pre_audit_amount",  columnDefinition = "decimal(24,6) COMMENT '细案待核销金额'")
    private BigDecimal activityPreAuditAmount;

    @ApiModelProperty(name = "costDetailDiffAmount", notes = "差异（费用单含税-细案）", value = "费用单含税-细案")
    @Column(name = "cost_detail_diff_amount", columnDefinition = "decimal(24,6) COMMENT '差异（费用单含税-细案）'")
    private BigDecimal costDetailDiffAmount;

    @ApiModelProperty(name = "confirmUserName", notes = "确认人名称", value = "确认人名称")
    @Column(name = "confirm_user_name",  length = 64, columnDefinition = "VARCHAR(64) COMMENT '确认人名称'")
    private String confirmUserName;

    @ApiModelProperty(name = "confirmUserAccount", notes = "确认人账号", value = "确认人账号")
    @Column(name = "confirm_user_account",  length = 64, columnDefinition = "VARCHAR(64) COMMENT '确认人账号'")
    private String confirmUserAccount;

    @ApiModelProperty(name = "confirmDate", notes = "确认日期", value = "确认日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "confirm_date", columnDefinition = "datetime COMMENT '确认日期(yyyy-MM-dd HH:mm:ss)'")
    private Date confirmDate;

    @ApiModelProperty(name = "businessFormatCode", notes = "业态")
    @Column(name = "business_format_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '业态'")
    private String businessFormatCode;

    @ApiModelProperty(name = "businessUnitCode", notes = "业务单元")
    @Column(name = "business_unit_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '业务单元'")
    private String businessUnitCode;

    @ApiModelProperty(name = "areaCode", notes = "业务区域")
    @Column(name = "area_code",  length = 40, columnDefinition = "VARCHAR(40) COMMENT '业务区域'")
    private String areaCode;

    @ApiModelProperty("档期名称")
    @Column(name = "slot_date_name",  length = 64, columnDefinition = "VARCHAR(64) COMMENT '档期名称'")
    private String slotDateName;

    @ApiModelProperty(name = "customerErpCode", notes = "售达方编码/客户编码")
    @Column(name = "customer_erp_code",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '售达方编码/客户编码'")
    private String customerErpCode;

    @ApiModelProperty(name = "customerName", notes = "售达方名称/客户名称")
    @Column(name = "customer_name",  length = 255, columnDefinition = "VARCHAR(255) COMMENT '售达方名称/客户名称'")
    private String customerName;

    @ApiModelProperty(name = "directName", notes = "系统名称")
    @Column(name = "direct_name",  length = 255, columnDefinition = "VARCHAR(255) COMMENT '系统名称'")
    private String directName;

    @ApiModelProperty(name = "md5UniqueKey", notes = "唯一键")
    @Column(name = "md5_unique_key",  length = 60, columnDefinition = "VARCHAR(60) COMMENT '唯一键'")
    private String md5UniqueKey;

    @ApiModelProperty(name = "allowanceKey", notes = "适用范围唯一键")
    @Column(name = "allowance_key",  length = 255, columnDefinition = "VARCHAR(255) COMMENT '适用范围唯一键'")
    private String allowanceKey;

    @ApiModelProperty(name = "salesOrgCode", notes = "销售组织编码")
    @Column(name = "sales_org_code",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售组织编码'")
    private String salesOrgCode;

    @ApiModelProperty(name = "salesOrgName", notes = "销售组织名称")
    @Column(name = "sales_org_name",  length = 255, columnDefinition = "VARCHAR(255) COMMENT '销售组织名称'")
    private String salesOrgName;

    @ApiModelProperty("关联零售商编码")
    @Column(name = "customer_retailer_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '关联零售商编码'")
    private String customerRetailerCode;

    @ApiModelProperty("关联零售商名称")
    @Column(name = "customer_retailer_name", length = 255, columnDefinition = "VARCHAR(255) COMMENT '关联零售商名称'")
    private String customerRetailerName;

    /**
     * 是否生成有差异费用处理（差异核对负差时，生成差异费用处理数据）
     */
    @ApiModelProperty(name = "isAlreadyDiff", notes = "是否生成有差异费用处理")
    @Column(name = "is_already_diff", length = 1, columnDefinition = "VARCHAR(32) COMMENT '是否生成有差异费用处理'")
    private String isAlreadyDiff;

    @ApiModelProperty(name = "isAddUp", notes = "是否累计")
    @Column(name = "is_add_up", length = 1, columnDefinition = "VARCHAR(1) COMMENT '是否累计'")
    private String isAddUp;

    /**
     * 差异类型
     * 1、多扣款无批复：未匹配上活动
     * 2、多扣款有批复：匹配上活动且差异确认金额为正值
     * 3、少扣款：匹配上活动且差异确认金额为负值
     * 4、无差异：匹配上活动且差异确认金额为0
     */
    @ApiModelProperty(name = "差异类型", notes = "差异类型")
    @Column(name = "diff_type",  length = 64, columnDefinition = "VARCHAR(64) COMMENT '差异类型'")
    private String diffType;

    /**
     * 差异使用
     * 1、数据字典：抵扣差异、待扣费、少扣费释放
     * 2、选择“抵扣差异”后，必须维护差异费用信息
     */
    @ApiModelProperty(name = "差异使用", notes = "差异使用")
    @Column(name = "diff_use",  length = 64, columnDefinition = "VARCHAR(64) COMMENT '差异使用'")
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String diffUse;

    /**
     * 差异确认金额
     * 默认为“费单-细案差异”金额
     */
    @ApiModelProperty(name = "差异确认金额", notes = "差异确认金额")
    @Column(name = "diff_confirm_amount",  columnDefinition = "decimal(24,6) COMMENT '差异确认金额'")
    private BigDecimal diffConfirmAmount;

    @ApiModelProperty(name = "是否确认差异", notes = "是否确认差异")
    @Column(name = "is_confirm_diff",  length = 8, columnDefinition = "VARCHAR(8) COMMENT '是否确认差异(Y,N)'")
    private String isConfirmDiff;

    @ApiModelProperty("数据来源")
    @Column(name = "data_source", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '数据来源'")
    private String dataSource;

    @ApiModelProperty("活动形式说明")
    @Column(name = "activity_form_desc", columnDefinition = "text COMMENT '活动形式说明'")
    private String activityFormDesc;

    @ApiModelProperty(name = "activityTypeCode", value = "活动分类编码", notes = "活动分类编码")
    @Column(name = "activity_type_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动分类编码'")
    private String activityTypeCode;

    @ApiModelProperty(name = "activityTypeName", value = "活动分类名称", notes = "活动分类名称")
    @Column(name = "activity_type_name", length = 255, columnDefinition = "VARCHAR(255) COMMENT '活动分类名称'")
    private String activityTypeName;
}
