package com.biz.crm.tpm.business.audit.fee.local.entity.check;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * @author LiuYiFan
 */
@ApiModel(value = "AuditFeeCheckCost", description = "核销费用核对关联费用单表")
@TableName("tpm_audit_fee_check_cost")
@Getter
@Setter
@Entity(name = "tpm_audit_fee_check_cost")
@org.hibernate.annotations.Table(appliesTo = "tpm_audit_fee_check_cost", comment = "核销费用核对关联费用单表(数据源至KMS)")
@Table(name = "tpm_audit_fee_check_cost",
        indexes = {
                @Index(name = "tpm_audit_fee_check_cost_index1", columnList = "audit_fee_check_code,company_cost_code"),
                @Index(name = "tpm_audit_fee_check_cost_index2", columnList = "create_time,id"),
                @Index(name = "tpm_audit_fee_check_cost_index3", columnList = "md5_unique_key"),
        })
public class AuditFeeCheckCost extends TenantFlagOpEntity {

    @ApiModelProperty("核销费用核对表扣费匹配单号")
    @Column(name = "audit_fee_check_code", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '核销费用核对表扣费匹配单号'")
    private String auditFeeCheckCode;

    @ApiModelProperty("扣费明细项编码")
    @Column(name = "company_cost_code", length = 128, columnDefinition = "VARCHAR(128) COMMENT '扣费明细项编码'")
    private String companyCostCode;

    @ApiModelProperty("扣费项编码")
    @Column(name = "deduction_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '扣费项编码'")
    private String deductionCode;

    @ApiModelProperty("扣费项名称")
    @Column(name = "deduction_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '扣费项名称'")
    private String deductionName;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(name = "业态[数据字典:mdm_business_format]", notes = "")
    @Column(name = "business_format_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '业态[数据字典:mdm_business_format]'")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(name = "业务单元[数据字典:mdm_business_unit]", notes = "")
    @Column(name = "business_unit_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务单元[数据字典:mdm_business_unit]'")
    private String businessUnitCode;

    @ApiModelProperty("业务区域")
    @Column(name = "business_area", length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务区域'")
    private String businessArea;

    @ApiModelProperty("关联零售商编码")
    @Column(name = "customer_retailer_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '关联零售商编码'")
    private String customerRetailerCode;

    @ApiModelProperty("关联零售商名称")
    @Column(name = "customer_retailer_name", length = 255, columnDefinition = "VARCHAR(255) COMMENT '关联零售商名称'")
    private String customerRetailerName;

    @ApiModelProperty("省编码(门店管理-省)")
    @Column(name = "province_code", length = 255, columnDefinition = "VARCHAR(255) COMMENT '省编码(门店管理-省)'")
    private String provinceCode;

    @ApiModelProperty("省名称(门店管理-省)")
    @Column(name = "province_name", length = 255, columnDefinition = "VARCHAR(255) COMMENT '省名称(门店管理-省)'")
    private String provinceName;

    @ApiModelProperty(name = "产品编码", notes = "产品编码", value = "产品编码")
    @Column(name = "product_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '产品编码'")
    private String productCode;

    @ApiModelProperty(name = "产品名称", notes = "产品名称", value = "产品名称")
    @Column(name = "product_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '产品名称'")
    private String productName;

    @ApiModelProperty("档期名称")
    @Column(name = "slot_date_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '档期名称'")
    private String slotDateName;

    @ApiModelProperty("费用日期 (kms单据日期)")
    @Column(name = "order_date", length = 64, columnDefinition = "VARCHAR(64) COMMENT '费用日期 (kms单据日期)'")
    private String orderDate;

    @ApiModelProperty("费用年月 (费用日期的年月)")
    @Column(name = "order_year_month", length = 64, columnDefinition = "VARCHAR(64) COMMENT '费用年月 (费用日期的年月)'")
    private String orderYearMonth;

    @ApiModelProperty("实际扣费年月")
    @DateTimeFormat(pattern = "yyyy-MM")
    @Column(name = "actual_year_month",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '实际扣费年月'")
    private String actualYearMonth;

    @ApiModelProperty("结案形式")
    @Column(name = "audit_way", length = 60, columnDefinition = "VARCHAR(60) COMMENT '结案形式'")
    private String auditWay;

    @ApiModelProperty("兑付方式")
    @Column(name = "cashing_type", length = 60, columnDefinition = "VARCHAR(60) COMMENT '兑付方式'")
    private String cashingType;

    @ApiModelProperty(name = "扣费金额含税", notes = "扣费金额含税")
    @Column(name = "deduction_amount_tax", columnDefinition = "Decimal(24,6) COMMENT '扣费金额含税'")
    private BigDecimal deductionAmountTax;

    @ApiModelProperty("未匹配pos原因")
    @Column(name = "pos_remark", length = 255, columnDefinition = "VARCHAR(255) COMMENT '未匹配pos原因'")
    private String posRemark;

    @ApiModelProperty(name = "md5UniqueKey", notes = "聚合唯一键")
    @Column(name = "md5_unique_key", length = 60, columnDefinition = "VARCHAR(60) COMMENT '聚合唯一键'")
    private String md5UniqueKey;

    @ApiModelProperty(name = "allowanceKey", notes = "适用范围唯一键")
    @Column(name = "allowance_key", length = 255, columnDefinition = "VARCHAR(255) COMMENT '适用范围唯一键'")
    private String allowanceKey;

    @ApiModelProperty("售达方编码/客户编码")
    @Column(name = "sold_to_party_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '售达方编码/客户编码'")
    private String soldToPartyCode;

    @ApiModelProperty("售达方名称/客户名称")
    @Column(name = "sold_to_party_name", length = 255, columnDefinition = "VARCHAR(255) COMMENT '售达方名称/客户名称'")
    private String soldToPartyName;

    @ApiModelProperty("送达方编码/门店编码")
    @Column(name = "delivery_party_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '送达方编码/门店编码'")
    private String deliveryPartyCode;

    @ApiModelProperty("送达方名称/门店名称")
    @Column(name = "delivery_party_name", length = 255, columnDefinition = "VARCHAR(255) COMMENT '送达方名称/门店名称'")
    private String deliveryPartyName;

    @ApiModelProperty("销售组织编码")
    @Column(name = "sales_org_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售组织编码'")
    private String salesOrgCode;

    @ApiModelProperty("销售组织名称")
    @Column(name = "sales_org_name", length = 255, columnDefinition = "VARCHAR(255) COMMENT '销售组织名称'")
    private String salesOrgName;

    @ApiModelProperty("数据来源")
    @Column(name = "data_source", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '数据来源'")
    private String dataSource;

    @ApiModelProperty("活动形式说明")
    @Column(name = "activity_form_desc", columnDefinition = "text COMMENT '活动形式说明'")
    private String activityFormDesc;

    // --------------------------------------------------------------------------

    @ApiModelProperty(name = "扣费方式", notes = "扣费方式")
    @Column(name = "deduction_type", length = 32, columnDefinition = "VARCHAR(32) COMMENT '扣费方式'")
    private String deductionType;

    // matchCode为空标记
    public static final String MATCH_CODE_NULL = "";
}
