package com.biz.crm.tpm.business.audit.fee.local.entity.check;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import lombok.Getter;
import lombok.Setter;

/**
 * @author LiuYiFan
 */
@ApiModel(value = "AuditFeeCheckDetailPlan", description = "核销费用核对关联细案表")
@TableName("tpm_audit_fee_check_detail_plan")
@Getter
@Setter
@Entity(name = "tpm_audit_fee_check_detail_plan")
@org.hibernate.annotations.Table(appliesTo = "tpm_audit_fee_check_detail_plan", comment = "核销费用核对关联细案表")
@Table(name = "tpm_audit_fee_check_detail_plan", indexes = {
        @Index(name = "terminal_code_idx", columnList = "terminal_code"),
        @Index(name = "tpm_audit_fee_check_detail_plan_index1", columnList = "audit_fee_check_code,detail_plan_item_code"),
})
public class AuditFeeCheckDetailPlan extends TenantFlagOpEntity {

    @ApiModelProperty(name = "核销费用核对表扣费匹配单号", notes = "核销费用核对表扣费匹配单号")
    @Column(name = "audit_fee_check_code", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '核销费用核对表扣费匹配单号'")
    private String auditFeeCheckCode;

    @ApiModelProperty(name = "活动细案明细编码", notes = "活动细案明细编码")
    @Column(name = "detail_plan_item_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动细案明细编码'")
    private String detailPlanItemCode;

    @ApiModelProperty(name = "活动细案明细名称", notes = "活动细案明细名称")
    @Column(name = "activity_detail_item_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '活动细案明细名称'")
    private String activityDetailItemName;

    @ApiModelProperty(name = "活动编号", notes = "活动编号")
    @Column(name = "detail_plan_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '活动编号 '")
    private String detailPlanCode;

    @ApiModelProperty(name = "活动名称", notes = "活动名称")
    @Column(name = "detail_plan_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '活动名称 '")
    private String detailPlanName;

    @ApiModelProperty("活动开始日期")
    @Column(name = "activity_begin_date", columnDefinition = "date COMMENT '活动开始日期'")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    private Date activityBeginDate;

    @ApiModelProperty("活动结束日期")
    @Column(name = "activity_end_date", columnDefinition = "date COMMENT '活动结束日期'")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    private Date activityEndDate;

    @ApiModelProperty(name = "activityYearMonth", value = "活动年月")
    @Column(name = "activity_year_month", columnDefinition = "VARCHAR(32) COMMENT '活动年月'")
    private String activityYearMonth;

    @ApiModelProperty("零售商编码")
    @Column(name = "system_code", length = 128, columnDefinition = "VARCHAR(128) COMMENT '零售商编码'")
    private String systemCode;

    @ApiModelProperty("零售商名称")
    @Column(name = "system_name", length = 225, columnDefinition = "VARCHAR(225) COMMENT '零售商名称'")
    private String systemName;

    @ApiModelProperty("区域编码")
    @Column(name = "region", length = 128, columnDefinition = "VARCHAR(128) COMMENT '区域编码'")
    private String region;

    @ApiModelProperty("区域名称")
    @Column(name = "region_name", length = 225, columnDefinition = "VARCHAR(225) COMMENT '区域名称'")
    private String regionName;

    @ApiModelProperty("省份编码")
    @Column(name = "province_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '省份编码'")
    private String provinceCode;

    @ApiModelProperty("省份名称")
    @Column(name = "province_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '省份名称'")
    private String provinceName;

    @ApiModelProperty("活动分类编码")
    @Column(name = "activity_type_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '活动分类编码 '")
    private String activityTypeCode;

    @ApiModelProperty("活动分类名称")
    @Column(name = "activity_type_name", length = 255, columnDefinition = "VARCHAR(255) COMMENT '活动分类名称 '")
    private String activityTypeName;

    @ApiModelProperty("活动形式编码")
    @Column(name = "activity_form_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '活动形式编码'")
    private String activityFormCode;

    @ApiModelProperty("活动形式名称")
    @Column(name = "activity_form_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT '活动形式名称'")
    private String activityFormName;

    @ApiModelProperty("结案形式")
    @Column(name = "audit_form", length = 32, columnDefinition = "VARCHAR(32) COMMENT '结案形式'")
    private String auditForm;

    @ApiModelProperty("购买方式")
    @Column(name = "buy_way", length = 32, columnDefinition = "VARCHAR(32) COMMENT '购买方式'")
    private String buyWay;

    @ApiModelProperty("核销方式")
    @Column(name = "write_off_method", length = 32, columnDefinition = "VARCHAR(32) COMMENT '核销方式'")
    private String writeOffMethod;

    @ApiModelProperty("客户编码")
    @Column(name = "customer_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '客户编码 '")
    private String customerCode;

    @ApiModelProperty("客户名称")
    @Column(name = "customer_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '客户名称 '")
    private String customerName;

    @ApiModelProperty("门店编码")
    @Column(name = "terminal_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '门店编码'")
    private String terminalCode;

    @ApiModelProperty("门店名称")
    @Column(name = "terminal_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '门店编码'")
    private String terminalName;

    @ApiModelProperty("产品编码")
    @Column(name = "product_code", length = 64, columnDefinition = "varchar(64) COMMENT '产品编码'")
    private String productCode;

    @ApiModelProperty("产品名称")
    @Column(name = "product_name", columnDefinition = "varchar(255) COMMENT '产品名称'")
    private String productName;

    @ApiModelProperty("档期名称")
    @Column(name = "schedule_name", columnDefinition = "varchar(64) COMMENT '档期名称'")
    private String scheduleName;

    @ApiModelProperty("申请金额")
    @Column(name = "apply_amount", precision = 24, scale = 6, columnDefinition = "decimal(24,6) COMMENT '申请金额(陈列方案用)'")
    private BigDecimal applyAmount;

    @ApiModelProperty("预估核销金额")
    @Column(name = "prediction_audit_amount", columnDefinition = "decimal(20,4) COMMENT '预估核销金额'")
    private BigDecimal predictionAuditAmount;

    @ApiModelProperty("已核销金额")
    @Column(name = "already_audit_amount", columnDefinition = "decimal(20,4) COMMENT '已核销金额'")
    private BigDecimal alreadyAuditAmount;

    @ApiModelProperty("可核销金额")
    @Column(name = "can_audit_amount", columnDefinition = "decimal(20,4) COMMENT '可核销金额'")
    private BigDecimal canAuditAmount;

    @ApiModelProperty("是否匹配pos")
    @Column(name = "is_pos", columnDefinition = "varchar(2) COMMENT '是否匹配pos'")
    private String isPos;

    @ApiModelProperty("匹配的posId")
    @Column(name = "pos_id", columnDefinition = "varchar(32) COMMENT '匹配的posId'")
    private String posId;

    @ApiModelProperty("所属销售机构编码")
    @Column(name = "sales_institution_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '所属销售机构编码'")
    private String salesInstitutionCode;

    @ApiModelProperty("所属销售机构")
    @Column(name = "sales_institution_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '所属销售机构'")
    private String salesInstitutionName;

    @ApiModelProperty("单件申请费用")
    @Column(name = "single_application_fee", columnDefinition = "decimal(24,6) COMMENT '单件申请费用'")
    private BigDecimal singleApplicationFee;

    @ApiModelProperty(name = "核销明细编号", notes = "核销编号")
    @Column(name = "audit_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '核销编号 '")
    private String auditCode;

    @ApiModelProperty(name = "核销明细编号", notes = "核销明细编号")
    @Column(name = "audit_detail_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '核销明细编号 '")
    private String auditDetailCode;

    @ApiModelProperty("是否按费用单生成")
    @Column(name = "is_created_by_fee", length = 10, columnDefinition = "VARCHAR(10) COMMENT '是否按费用单生成[BooleanEnum.Capital]'")
    private String isCreatedByFee;

    @ApiModelProperty("是否按结算单生成")
    @Column(name = "is_created_by_settlement", length = 10, columnDefinition = "VARCHAR(10) COMMENT '是否按结算单生成[BooleanEnum.Capital]'")
    private String isCreatedBySettlement;

    @ApiModelProperty("活动形式说明")
    @Column(name = "activity_form_desc", columnDefinition = "text COMMENT '活动形式说明'")
    private String activityFormDesc;


    /**
     * 存储在分摊表 {@link com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheckDetailPlanShare}
     */
    @ApiModelProperty("扣费匹配分摊金额，一个细案可分摊多个核对数据，故此属性根据核对编号存在不同的值")
    @TableField(exist = false)
    private BigDecimal auditFeeCheckShareAmount;
    @ApiModelProperty("待补录金额（元）")
    @TableField(exist = false)
    private BigDecimal toBeSupplementedAmount;
    @ApiModelProperty("本次核销金额（元）")
    @TableField(exist = false)
    private BigDecimal thisAuditAmount;
}
