package com.biz.crm.tpm.business.audit.fee.local.entity.check;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import lombok.Getter;
import lombok.Setter;

/**
 * @author LiuYiFan
 */
@ApiModel(value = "AuditFeeCheckDetailPlanShare", description = "核销费用核对关联细案分摊表")
@TableName("tpm_audit_fee_check_detail_plan_share")
@Getter
@Setter
@Entity(name = "tpm_audit_fee_check_detail_plan_share")
@org.hibernate.annotations.Table(appliesTo = "tpm_audit_fee_check_detail_plan_share", comment = "核销费用核对关联细案分摊表")
@Table(indexes = {
    @Index(name = "tpm_audit_fee_check_detail_plan_share_index1", columnList = "audit_fee_check_code, detail_plan_item_code"),
})
public class AuditFeeCheckDetailPlanShare extends TenantFlagOpEntity {

    @ApiModelProperty(name = "核销费用核对表扣费匹配单号", notes = "核销费用核对表扣费匹配单号")
    @Column(name = "audit_fee_check_code", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '核销费用核对表扣费匹配单号'")
    private String auditFeeCheckCode;

    @ApiModelProperty(name = "活动细案明细编码", notes = "活动细案明细编码")
    @Column(name = "detail_plan_item_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动细案明细编码'")
    private String detailPlanItemCode;

    @ApiModelProperty("扣费匹配分摊金额")
    @Column(name = "audit_fee_check_share_amount", columnDefinition = "decimal(24,6) COMMENT '扣费匹配分摊金额'")
    private BigDecimal auditFeeCheckShareAmount;

    @ApiModelProperty("待补录金额（元）")
    @Column(name = "to_be_supplemented_amount", columnDefinition = "decimal(24,6) COMMENT '待补录金额（元）'")
    private BigDecimal toBeSupplementedAmount;

    @ApiModelProperty("本次核销金额（元）")
    @Column(name = "this_audit_amount", columnDefinition = "decimal(24,6) COMMENT '本次核销金额（元）'")
    private BigDecimal thisAuditAmount;
}
