package com.biz.crm.tpm.business.audit.fee.local.entity.check;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * @author LiuYiFan
 */
@ApiModel(value = "AuditFeeCheckDiff", description = "核销费用核对关联差异费用表")
@TableName("tpm_audit_fee_check_diff")
@Getter
@Setter
@Entity(name = "tpm_audit_fee_check_diff")
@org.hibernate.annotations.Table(appliesTo = "tpm_audit_fee_check_diff", comment = "核销费用核对关联差异费用表")
@Table(name = "tpm_audit_fee_check_diff", indexes = {
    @Index(name = "tpm_audit_fee_check_diff_index1", columnList = "audit_fee_check_code,fee_diff_ledger_code"),
    @Index(name = "tpm_audit_fee_check_diff_index2", columnList = "audit_fee_check_deduct_code,fee_diff_ledger_code")
})
public class AuditFeeCheckDiff extends TenantFlagOpEntity {

    @ApiModelProperty(name = "auditFeeCheckCode", notes = "核销费用核对表扣费匹配单号来源")
    @Column(name = "audit_fee_check_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '核销费用核对表扣费匹配单号来源'")
    private String auditFeeCheckCode;

    @ApiModelProperty(name = "auditFeeCheckDeductCode", notes = "核销费用核对表扣费匹配单号抵扣")
    @Column(name = "audit_fee_check_deduct_code", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT '核销费用核对表扣费匹配单号抵扣'")
    private String auditFeeCheckDeductCode;

    @ApiModelProperty(name = "feeDiffLedgerCode", notes = "差异费用编码")
    @Column(name = "fee_diff_ledger_code", length = 128, columnDefinition = "VARCHAR(128) COMMENT '差异费用编码'")
    private String feeDiffLedgerCode;

    @ApiModelProperty(name = "status", notes = "状态[字典：audit_fee_diff_status]")
    @Column(name = "status", length = 32, columnDefinition = "VARCHAR(32) COMMENT '状态[字典：audit_fee_diff_status]'")
    private String status;

    @ApiModelProperty(name = "year", notes = "年份")
    @Column(name = "year", length = 32, columnDefinition = "VARCHAR(6) COMMENT '年份'")
    private String year;

    @ApiModelProperty(name = "月份", notes = "月份")
    @Column(name = "month", length = 32, columnDefinition = "VARCHAR(4) COMMENT '月份'")
    private String month;

    @ApiModelProperty("费用所属年月")
    @Column(name = "fee_year_month", length = 20, columnDefinition = "VARCHAR(8) COMMENT '费用所属年月 '")
    private String feeYearMonth;

    @ApiModelProperty(name = "businessFormatCode", notes = "业态")
    @Column(name = "business_format_code", length = 128, columnDefinition = "VARCHAR(128) COMMENT '业态'")
    private String businessFormatCode;

    @ApiModelProperty(name = "businessUnitCode", notes = "业务单元")
    @Column(name = "business_unit_code", length = 128, columnDefinition = "VARCHAR(128) COMMENT '业务单元'")
    private String businessUnitCode;

    @ApiModelProperty(name = "salesOrgCode", notes = "销售组织编码")
    @Column(name = "sales_org_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售组织编码 '")
    private String salesOrgCode;

    @ApiModelProperty(name = "salesOrgName", notes = "销售组织名称")
    @Column(name = "sales_org_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '销售组织名称 '")
    private String salesOrgName;

    @ApiModelProperty(name = "businessAreaCode", notes = "业务区域编码")
    @Column(name = "business_area_code", length = 32, columnDefinition = "VARCHAR(10) COMMENT '业务区域编码'")
    private String businessAreaCode;

    @ApiModelProperty(name = "businessAreaName", value = "业务区域名称")
    @Column(name = "business_area_name", length = 255, columnDefinition = "VARCHAR(10) COMMENT '业务区域名称'")
    private String businessAreaName;

    @ApiModelProperty(name = "零售商编码")
    @Column(name = "retailer_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '零售商编码'")
    private String retailerCode;

    @ApiModelProperty(name = "零售商名称")
    @Column(name = "retailer_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '零售商名称'")
    private String retailerName;

    @ApiModelProperty("售达方编码")
    @Column(name = "sold_to_party_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '售达方编码'")
    private String soldToPartyCode;

    @ApiModelProperty("售达方名称")
    @Column(name = "sold_to_party_name", length = 255, columnDefinition = "VARCHAR(255) COMMENT '售达方名称'")
    private String soldToPartyName;

    @ApiModelProperty("送达方编码")
    @Column(name = "delivery_party_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '售达方编码'")
    private String deliveryPartyCode;

    @ApiModelProperty("送达方名称")
    @Column(name = "delivery_party_name", length = 255, columnDefinition = "VARCHAR(255) COMMENT '售达方名称'")
    private String deliveryPartyName;

    @ApiModelProperty(name = "activitiesType", notes = "活动分类")
    @Column(name = "activities_type", length = 64, columnDefinition = "VARCHAR(64) COMMENT '活动分类 '")
    private String activitiesType;

    @ApiModelProperty(name = "activitiesTypeName", notes = "活动分类名称")
    @Column(name = "activities_type_name", length = 255, columnDefinition = "VARCHAR(255) COMMENT '活动分类 '")
    private String activitiesTypeName;

    @ApiModelProperty(name = "activityFormCode", notes = "活动形式编码")
    @Column(name = "activity_form_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '活动形式编码 '")
    private String activityFormCode;

    @ApiModelProperty(name = "activityFormName", notes = "活动形式名称")
    @Column(name = "activity_form_name", length = 255, columnDefinition = "VARCHAR(255) COMMENT '活动形式名称 '")
    private String activityFormName;

    @ApiModelProperty(name = "diffAmount", notes = "差异金额", value = "差异金额")
    @Column(name = "diff_amount", columnDefinition = "Decimal(24,6) COMMENT '差异金额 '")
    private BigDecimal diffAmount;

    @ApiModelProperty(name = "recoveredAmount", notes = "已追回金额", value = "已追回金额")
    @Column(name = "recovered_amount", columnDefinition = "Decimal(24,6) COMMENT '已追回金额 '")
    private BigDecimal recoveredAmount;

    @ApiModelProperty(name = "beRecoveredAmount", notes = "待追回金额", value = "待追回金额")
    @Column(name = "be_recovered_amount", columnDefinition = "Decimal(24,6) COMMENT '待追回金额 '")
    private BigDecimal beRecoveredAmount;

    @ApiModelProperty(name = "followUpPerson", notes = "跟进人", value = "跟进人")
    @Column(name = "follow_up_person", length = 64, columnDefinition = "VARCHAR(64) COMMENT '跟进人 '")
    private String followUpPerson;

    @ApiModelProperty(name = "recoveredTime", notes = "完全追回时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @Column(name = "recovered_time",  columnDefinition = "datetime COMMENT '完全追回时间(yyyy-MM-dd HH:mm:ss)'")
    private Date recoveredTime;

    @ApiModelProperty(name = "dataSource", notes = "数据来源", value = "数据来源")
    @Column(name = "data_source", length = 32, columnDefinition = "VARCHAR(32) COMMENT '数据来源'")
    private String dataSource;

    @ApiModelProperty(name = "confirmDiffAmount", notes = "零售确认差异金额", value = "零售确认差异金额")
    @Column(name = "confirm_diff_amount", columnDefinition = "Decimal(24,6) COMMENT '确认差异金额 '")
    private BigDecimal confirmDiffAmount;

    @ApiModelProperty(name = "isEffectStatement", notes = "是否影响结算", value = "是否影响结算")
    @Column(name = "is_effect_statement", length = 1, columnDefinition = "VARCHAR(1) COMMENT '是否影响结算'")
    private String isEffectStatement;

    /**
     * 抵扣金额
     * 存储在分摊表 {@link com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheckDiffShare}
     */
    @ApiModelProperty(name = "deductAmount", notes = "抵扣金额", value = "抵扣金额")
    @TableField(exist = false)
    private BigDecimal deductAmount;
}
