package com.biz.crm.tpm.business.audit.fee.local.entity.check;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import lombok.Getter;
import lombok.Setter;

/**
 * @author liyang
 * @date 2023/10/22
 */
@ApiModel(value = "AuditFeeCheckDiffShare", description = "核销费用核对关联差异费用分摊表")
@TableName("tpm_audit_fee_check_diff_share")
@Getter
@Setter
@Entity(name = "tpm_audit_fee_check_diff_share")
@org.hibernate.annotations.Table(appliesTo = "tpm_audit_fee_check_diff_share", comment = "核销费用核对关联差异费用分摊表")
@Table(indexes = {
    @Index(name = "tpm_audit_fee_check_diff_share_index1", columnList = "audit_fee_check_deduct_code, fee_diff_ledger_code")
})
public class AuditFeeCheckDiffShare extends TenantFlagOpEntity {

  @ApiModelProperty(name = "auditFeeCheckDeductCode", notes = "核销费用核对表扣费匹配单号抵扣")
  @Column(name = "audit_fee_check_deduct_code", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '核销费用核对表扣费匹配单号抵扣'")
  private String auditFeeCheckDeductCode;

  @ApiModelProperty(name = "feeDiffLedgerCode", notes = "差异费用编码")
  @Column(name = "fee_diff_ledger_code", length = 128, columnDefinition = "VARCHAR(128) COMMENT '差异费用编码'")
  private String feeDiffLedgerCode;

  @ApiModelProperty(name = "deductAmount", notes = "抵扣金额", value = "抵扣金额")
  @Column(name = "deduct_amount", columnDefinition = "Decimal(24,6) COMMENT '抵扣金额 '")
  private BigDecimal deductAmount;
}
