package com.biz.crm.tpm.business.audit.fee.local.entity.check;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Description:核销费用核对POS表
 * @Author qiancheng
 * @Date 2023/5/29
 */
@ApiModel(value = "AuditFeeCheckPos", description = "核销费用核对POS表")
@TableName("tpm_audit_fee_check_pos")
@Getter
@Setter
@Entity(name = "tpm_audit_fee_check_pos")
@org.hibernate.annotations.Table(appliesTo = "tpm_audit_fee_check_pos", comment = "核销费用核对POS表")
@Table(name = "tpm_audit_fee_check_pos",
        indexes = {
                @Index(name = "tpm_audit_fee_check_pos_index1", columnList = "create_time,id", unique = false),
                @Index(name = "tpm_audit_fee_check_pos_index2", columnList = "match_code", unique = true),
                @Index(name = "tpm_audit_fee_check_pos_index3", columnList = "direct_code", unique = false),
                @Index(name = "tpm_audit_fee_check_pos_index4", columnList = "terminal_code", unique = false),
                @Index(name = "tpm_audit_fee_check_pos_index5", columnList = "product_code", unique = false),
                @Index(name = "tpm_audit_fee_check_pos_index6", columnList = "sales_date", unique = false),
        })
public class AuditFeeCheckPos extends TenantFlagOpEntity {


    @ApiModelProperty(name = "扣费匹配汇总单号", notes = "扣费匹配汇总单号")
    @Column(name = "match_head_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '扣费匹配单号'")
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String matchHeadCode;

    @ApiModelProperty(name = "扣费匹配单号", notes = "扣费匹配单号")
    @Column(name = "match_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '扣费匹配单号'")
    private String matchCode;

    @ApiModelProperty(name = "确认状态", notes = "确认状态")
    @Column(name = "match_status", length = 1, columnDefinition = "VARCHAR(1) default 'N' COMMENT '确认状态'")
    private String matchStatus;

    @ApiModelProperty(name = "匹配类型", notes = "匹配类型")
    @Column(name = "match_type", length = 16, columnDefinition = "VARCHAR(16) default 'auto_match' COMMENT '匹配类型'")
    private String matchType;

    @ApiModelProperty(name = "确认时间", notes = "确认时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "match_time", columnDefinition = "datetime COMMENT '确认时间'")
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private Date matchTime;

    @ApiModelProperty(name = "businessFormatCode", notes = "业态")
    @Column(name = "business_format_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '业态'")
    private String businessFormatCode;

    @ApiModelProperty(name = "businessUnitCode", notes = "业务单元")
    @Column(name = "business_unit_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务单元'")
    private String businessUnitCode;

    @ApiModelProperty(name = "业务区域", notes = "业务区域")
    @Column(name = "business_area", length = 64, columnDefinition = "VARCHAR(64) COMMENT '业务区域'")
    private String businessArea;

    @ApiModelProperty(name = "directCode", notes = "系统编码")
    @Column(name = "direct_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '系统编码'")
    private String directCode;

    @ApiModelProperty("关联零售商编码")
    @Column(name = "customer_retailer_code", length = 32, columnDefinition = "varchar(32) COMMENT '关联零售商编码'")
    private String customerRetailerCode;

    @ApiModelProperty("关联零售商名称")
    @Column(name = "customer_retailer_name", length = 255, columnDefinition = "VARCHAR(255) COMMENT '关联零售商名称'")
    private String customerRetailerName;

    @ApiModelProperty(name = "directName", notes = "系统名称")
    @Column(name = "direct_name", length = 255, columnDefinition = "VARCHAR(255) COMMENT '系统名称'")
    private String directName;

    @ApiModelProperty("省编码(门店管理-省)")
    @Column(name = "province_code", length = 32, columnDefinition = "varchar(32) COMMENT '省编码(门店管理-省)'")
    private String provinceCode;

    @ApiModelProperty("省名称(门店管理-省)")
    @Column(name = "province_name", length = 128, columnDefinition = "varchar(128) COMMENT '省名称(门店管理-省)'")
    private String provinceName;

    @ApiModelProperty("渠道编码")
    @Column(name = "channel_code", length = 32, columnDefinition = "varchar(32) COMMENT '渠道编码'")
    private String channelCode;

    @ApiModelProperty("渠道名称")
    @Column(name = "channel_name", length = 128, columnDefinition = "varchar(128) COMMENT '渠道名称'")
    private String channelName;

    @ApiModelProperty(name = "terminalCode", notes = "门店编码", value = "门店编码")
    @Column(name = "terminal_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '门店编码'")
    private String terminalCode;

    @ApiModelProperty(name = "terminalName", notes = "门店名称", value = "门店名称")
    @Column(name = "terminal_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '门店名称'")
    private String terminalName;

    @ApiModelProperty(name = "productCode", notes = "产品编码", value = "产品编码")
    @Column(name = "product_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '产品编码'")
    private String productCode;

    @ApiModelProperty(name = "产品名称", notes = "产品名称", value = "产品名称")
    @Column(name = "product_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '产品名称'")
    private String productName;

    @ApiModelProperty(name = "unitCode", value = "单位编码", notes = "单位编码")
    @Column(name = "unit_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '单位编码'")
    private String unitCode;

    @ApiModelProperty(name = "unit", value = "单位名称", notes = "单位名称")
    @Column(name = "unit_name", length = 32, columnDefinition = "VARCHAR(32) COMMENT '单位名称'")
    private String unitName;

    @ApiModelProperty(name = "数量", notes = "数量")
    @Column(name = "product_number", columnDefinition = "Decimal(20,6) COMMENT '数量'")
    private BigDecimal productNumber;

    @ApiModelProperty("年月")
    @Column(name = "year_month_ly", length = 8, columnDefinition = "VARCHAR(8) COMMENT '年月'")
    private String yearMonthLy;

    @ApiModelProperty("销售日期")
    @Column(name = "sales_date_str", length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售日期'")
    private String salesDateStr;

    @ApiModelProperty("销售日期")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "sales_date", columnDefinition = "datetime COMMENT '销售日期'")
    private Date salesDate;

    @ApiModelProperty(name = "促销扣款", notes = "促销扣款")
    @Column(name = "promotion_deduction", columnDefinition = "Decimal(20,6) COMMENT '促销扣款'")
    private BigDecimal promotionDeduction;

    @ApiModelProperty(name = "分摊促销扣款", notes = "分摊促销扣款")
    @Column(name = "share_promotion_deduction", columnDefinition = "Decimal(20,6) COMMENT '分摊促销扣款'")
    private BigDecimal sharePromotionDeduction;

    @ApiModelProperty(name = "单件促销扣款", notes = "单件促销扣款")
    @Column(name = "one_promotion_deduction", columnDefinition = "Decimal(20,6) COMMENT '单件促销扣款'")
    private BigDecimal onePromotionDeduction;

    @ApiModelProperty(name = "活动细案编码", notes = "活动细案编码")
    @Column(name = "activity_detail_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '活动细案编码'")
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String activityDetailCode;

    @ApiModelProperty(name = "活动细案名称", notes = "活动细案名称")
    @Column(name = "activity_detail_name", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '活动细案名称'")
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String activityDetailName;

    @ApiModelProperty(name = "活动细案明细编码", notes = "活动细案明细编码")
    @Column(name = "activity_detail_item_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动细案明细编码'")
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String activityDetailItemCode;

    @ApiModelProperty(name = "活动细案明细名称", notes = "活动细案明细名称")
    @Column(name = "activity_detail_item_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '活动细案明细名称'")
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String activityDetailItemName;

    @ApiModelProperty(name = "单件申请费用", notes = "单件申请费用")
    @Column(name = "one_application_fee", columnDefinition = "Decimal(20,6) COMMENT '单件申请费用'")
    private BigDecimal oneApplicationFee;

    @ApiModelProperty(name = "单件费用差异", notes = "单件费用差异")
    @Column(name = "one_diff_amount", columnDefinition = "Decimal(20,6) COMMENT '单件费用差异'")
    private BigDecimal oneDiffAmount;

    @ApiModelProperty(name = "差异总金额/系统计算", notes = "差异总金额/系统计算")
    @Column(name = "total_diff_amount", columnDefinition = "Decimal(20,6) COMMENT '差异总金额/系统计算'")
    private BigDecimal totalDiffAmount;

    @ApiModelProperty(name = "差异总金额/人为调整(最终,页面展示)", notes = "差异总金额/人为调整(最终,页面展示)")
    @Column(name = "total_diff_final_amount", columnDefinition = "Decimal(20,6) COMMENT '差异总金额/人为调整(最终,页面展示)'")
    private BigDecimal totalDiffFinalAmount;

    @ApiModelProperty(name = "差异类型", notes = "差异类型")
    @Column(name = "diff_type", length = 32, columnDefinition = "VARCHAR(32) COMMENT '差异类型'")
    private String diffType;

    @ApiModelProperty(name = "差异使用", notes = "差异使用")
    @Column(name = "diff_use", length = 32, columnDefinition = "VARCHAR(32) COMMENT '差异使用'")
    private String diffUse;

    @ApiModelProperty(name = "费用单编码", notes = "费用单编码")
    @Column(name = "company_cost_code", length = 128, columnDefinition = "VARCHAR(128) COMMENT '费用单编码'")
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String companyCostCode;

    @ApiModelProperty("费用单行号")
    @Column(name = "item_index", length = 20, columnDefinition = "VARCHAR(20) COMMENT '费用单行号'")
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String itemIndex;

    @ApiModelProperty("费用核对单号")
    @Column(name = "fee_check_match_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '费用核对单号'")
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String feeCheckMatchCode;

    @ApiModelProperty("是否已匹配费单")
    @Column(name = "is_match_cost", length = 1, columnDefinition = "VARCHAR(1) default 'N' COMMENT '是否已匹配费单'")
    private String isMatchCost;

    @ApiModelProperty("是否已匹配活动")
    @Column(name = "is_match_activity", length = 1, columnDefinition = "VARCHAR(1) default 'N' COMMENT '是否已匹配活动'")
    private String isMatchActivity;

    @ApiModelProperty("匹配活动类型")
    @Column(name = "match_activity_type", length = 8, columnDefinition = "VARCHAR(8) COMMENT '匹配活动类型'")
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String matchActivityType;

    @ApiModelProperty("零售商门店编码")
    @Column(name = "ka_store_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '零售商门店编码'")
    private String kaStoreCode;

    @ApiModelProperty("零售商门店名称")
    @Column(name = "ka_store_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '零售商门店名称'")
    private String kaStoreName;

    @ApiModelProperty(name = "匹配模板编码", notes = "匹配模板编码")
    @Column(name = "match_template_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '匹配模板编码'")
    private String matchTemplateCode;

    @ApiModelProperty(name = "匹配模板名称", notes = "匹配模板名称")
    @Column(name = "match_template_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '匹配模板名称'")
    private String matchTemplateName;

    @ApiModelProperty("所属销售机构编码")
    @Column(name = "sales_institution_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '所属销售机构编码'")
    private String salesInstitutionCode;

    @ApiModelProperty("所属销售机构编码")
    @Column(name = "sales_institution_erp_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '所属销售机构编码'")
    private String salesInstitutionErpCode;


    @ApiModelProperty("所属销售机构")
    @Column(name = "sales_institution_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '所属销售机构'")
    private String salesInstitutionName;

    @ApiModelProperty("所属销售组织(组)编码")
    @Column(name = "sales_org_erp_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '所属销售组织(组)编码'")
    private String salesOrgErpCode;

    @ApiModelProperty("所属销售组织(组)编码")
    @Column(name = "sales_org_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '所属销售组织(组)编码'")
    private String salesOrgCode;

    @ApiModelProperty("所属销售组织(组)名称")
    @Column(name = "sales_org_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '所属销售组织(组)名称'")
    private String salesOrgName;

    @ApiModelProperty(name = "数据来源;数据字典[pos_source]", notes = "数据来源;数据字典[pos_source]")
    @Column(name = "data_source", length = 32, columnDefinition = "VARCHAR(32) COMMENT '数据来源;数据字典[pos_source]'")
    private String dataSource;

    @ApiModelProperty(name = "唯一标记[数据来源+零售商+单店+单品+单日+渠道]", notes = "唯一标记[数据来源+零售商+单店+单品+单日+渠道]")
    @Column(name = "only_key", unique = true, nullable = false, length = 256, columnDefinition = "VARCHAR(512) COMMENT '唯一标记[数据来源+零售商+单店+单品+单日+渠道]'")
    private String onlyKey;

}
