package com.biz.crm.tpm.business.audit.fee.local.entity.check;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 核销费用核对POS差异费用汇总表
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2023-11-06 19:44
 */
@ApiModel(value = "AuditFeeCheckPosHead", description = "核销费用核对POS差异费用汇总表")
@TableName("tpm_audit_fee_check_pos_head")
@Getter
@Setter
@Entity(name = "tpm_audit_fee_check_pos_head")
@org.hibernate.annotations.Table(appliesTo = "tpm_audit_fee_check_pos_head", comment = "核销费用核对POS差异费用汇总表")
@Table(name = "tpm_audit_fee_check_pos_head",
        indexes = {
                @Index(name = "tpm_audit_fee_check_pos_head_index1", columnList = "create_time,id", unique = false),
                @Index(name = "tpm_audit_fee_check_pos_head_index2", columnList = "match_head_code", unique = true),
                @Index(name = "tpm_audit_fee_check_pos_head_index3", columnList = "direct_code", unique = false),
                @Index(name = "tpm_audit_fee_check_pos_head_index4", columnList = "terminal_code", unique = false),
                @Index(name = "tpm_audit_fee_check_pos_head_index5", columnList = "product_code", unique = false),
        })
public class AuditFeeCheckPosHead extends TenantFlagOpEntity {

    @ApiModelProperty(name = "扣费匹配汇总单号", notes = "扣费匹配汇总单号")
    @Column(name = "match_head_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '扣费匹配汇总单号'")
    private String matchHeadCode;

    @ApiModelProperty(name = "匹配类型", notes = "匹配类型")
    @Column(name = "match_type", length = 16, columnDefinition = "VARCHAR(16) default 'auto_match' COMMENT '匹配类型'")
    private String matchType;

    @ApiModelProperty(name = "businessFormatCode", notes = "业态")
    @Column(name = "business_format_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '业态'")
    private String businessFormatCode;

    @ApiModelProperty(name = "businessUnitCode", notes = "业务单元")
    @Column(name = "business_unit_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务单元'")
    private String businessUnitCode;

    @ApiModelProperty(name = "year", notes = "年份")
    @Column(name = "year", length = 4, columnDefinition = "VARCHAR(4) COMMENT '年份'")
    private String year;

    @ApiModelProperty(name = "月份", notes = "月份")
    @Column(name = "month", length = 2, columnDefinition = "VARCHAR(2) COMMENT '月份'")
    private String month;

    @ApiModelProperty("年月")
    @Column(name = "year_month_ly", length = 8, columnDefinition = "VARCHAR(8) COMMENT '年月'")
    private String yearMonthLy;

    @ApiModelProperty(name = "业务区域", notes = "业务区域")
    @Column(name = "business_area", length = 64, columnDefinition = "VARCHAR(64) COMMENT '业务区域'")
    private String businessArea;

    @ApiModelProperty(name = "directCode", notes = "系统编码")
    @Column(name = "direct_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '系统编码'")
    private String directCode;

    @ApiModelProperty("关联零售商编码")
    @Column(name = "customer_retailer_code", length = 32, columnDefinition = "varchar(32) COMMENT '关联零售商编码'")
    private String customerRetailerCode;

    @ApiModelProperty("关联零售商名称")
    @Column(name = "customer_retailer_name", length = 255, columnDefinition = "VARCHAR(255) COMMENT '关联零售商名称'")
    private String customerRetailerName;

    @ApiModelProperty(name = "directName", notes = "系统名称")
    @Column(name = "direct_name", length = 255, columnDefinition = "VARCHAR(255) COMMENT '系统名称'")
    private String directName;

    @ApiModelProperty("省编码(门店管理-省)")
    @Column(name = "province_code", length = 32, columnDefinition = "varchar(32) COMMENT '省编码(门店管理-省)'")
    private String provinceCode;

    @ApiModelProperty("省名称(门店管理-省)")
    @Column(name = "province_name", length = 128, columnDefinition = "varchar(128) COMMENT '省名称(门店管理-省)'")
    private String provinceName;

    @ApiModelProperty("渠道编码")
    @Column(name = "channel_code", length = 32, columnDefinition = "varchar(32) COMMENT '渠道编码'")
    private String channelCode;

    @ApiModelProperty("渠道名称")
    @Column(name = "channel_name", length = 128, columnDefinition = "varchar(128) COMMENT '渠道名称'")
    private String channelName;

    @ApiModelProperty(name = "terminalCode", notes = "门店编码", value = "门店编码")
    @Column(name = "terminal_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '门店编码'")
    private String terminalCode;

    @ApiModelProperty(name = "terminalName", notes = "门店名称", value = "门店名称")
    @Column(name = "terminal_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '门店名称'")
    private String terminalName;

    @ApiModelProperty(name = "productCode", notes = "产品编码", value = "产品编码")
    @Column(name = "product_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '产品编码'")
    private String productCode;

    @ApiModelProperty(name = "产品名称", notes = "产品名称", value = "产品名称")
    @Column(name = "product_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '产品名称'")
    private String productName;


    @ApiModelProperty(name = "差异总金额/系统计算", notes = "差异总金额/系统计算")
    @Column(name = "total_diff_amount", columnDefinition = "Decimal(20,6) COMMENT '差异总金额/系统计算'")
    private BigDecimal totalDiffAmount;

    @ApiModelProperty(name = "差异总金额/人为调整(最终,页面展示)", notes = "差异总金额/人为调整(最终,页面展示)")
    @Column(name = "total_diff_final_amount", columnDefinition = "Decimal(20,6) COMMENT '差异总金额/人为调整(最终,页面展示)'")
    private BigDecimal totalDiffFinalAmount;

    @ApiModelProperty(name = "差异类型", notes = "差异类型")
    @Column(name = "diff_type", length = 32, columnDefinition = "VARCHAR(32) COMMENT '差异类型'")
    private String diffType;

    @ApiModelProperty(name = "差异使用", notes = "差异使用")
    @Column(name = "diff_use", length = 32, columnDefinition = "VARCHAR(32) COMMENT '差异使用'")
    private String diffUse;

    @ApiModelProperty(name = "数据来源;数据字典[pos_source]", notes = "数据来源;数据字典[pos_source]")
    @Column(name = "data_source", length = 32, columnDefinition = "VARCHAR(32) COMMENT '数据来源;数据字典[pos_source]'")
    private String dataSource;

}
