package com.biz.crm.tpm.business.audit.fee.local.entity.check;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * POS活动核对和差异费用关系表
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2023-10-06 15:29
 */
@ApiModel(value = "AuditFeeCheckPosLedger", description = "POS活动核对和差异费用关系表")
@TableName("tpm_audit_fee_check_pos_ledger")
@Getter
@Setter
@Entity(name = "tpm_audit_fee_check_pos_ledger")
@org.hibernate.annotations.Table(appliesTo = "tpm_audit_fee_check_pos_ledger", comment = "POS活动核对和差异费用关系表")
@Table(name = "tpm_audit_fee_check_pos_ledger",
        indexes = {
                @Index(name = "tpm_audit_fee_check_pos_ledger_index1", columnList = "match_code", unique = false),
                @Index(name = "tpm_audit_fee_check_pos_ledger_index2", columnList = "fee_diff_ledger_code", unique = false),
        })
public class AuditFeeCheckPosLedger extends TenantFlagOpEntity {

    @ApiModelProperty(name = "扣费匹配汇总单号", notes = "扣费匹配汇总单号")
    @Column(name = "match_head_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '扣费匹配汇总单号'")
    private String matchHeadCode;

    @ApiModelProperty(name = "扣费匹配单号", notes = "扣费匹配单号")
    @Column(name = "match_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '扣费匹配单号'")
    private String matchCode;

    @ApiModelProperty(name = "feeDiffLedgerCode", notes = "差异费用编码")
    @Column(name = "fee_diff_ledger_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '差异费用编码'")
    private String feeDiffLedgerCode;

    @ApiModelProperty(name = "deductAmount", notes = "抵扣金额", value = "抵扣金额")
    @Column(name = "deduct_amount", columnDefinition = "Decimal(24,6) COMMENT '抵扣金额 '")
    private BigDecimal deductAmount;

}
