package com.biz.crm.tpm.business.audit.fee.local.entity.check;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author LiuYiFan
 */
@ApiModel(value = "AuditFeeCheckStatement", description = "核销费用核对关联结算单单表")
@TableName("tpm_audit_fee_check_statement")
@Getter
@Setter
@Entity(name = "tpm_audit_fee_check_statement")
@org.hibernate.annotations.Table(appliesTo = "tpm_audit_fee_check_statement", comment = "核销费用核对关联结算单单表(数据源至KMS)")
@Table(name = "tpm_audit_fee_check_statement",indexes = {@Index(name = "tpm_audit_fee_check_statement_index1", columnList = "audit_fee_check_code"),
})
@Deprecated
public class AuditFeeCheckStatement extends TenantFlagOpEntity {


    @ApiModelProperty(name = "核销费用核对表扣费匹配单号", notes = "核销费用核对表扣费匹配单号")
    @Column(name = "audit_fee_check_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '核销费用核对表扣费匹配单号'")
    private String auditFeeCheckCode;


    @ApiModelProperty(name = "企业结算单编码", notes = "企业结算单编码")
    @Column(name = "statement_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '企业结算单编码'")
    private String  statementCode;

    @ApiModelProperty(name = "企业结算单名称", notes = "企业结算单名称")
    @Column(name = "statement_name",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '企业结算单名称'")
    private String  statementName;


    @ApiModelProperty(name = "过账日期", notes = "过账日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Column(name = "posting_date",   columnDefinition = "datetime COMMENT '过账日期'")
    private Date postingDate;


    @ApiModelProperty(name = "发生日期", notes = "发生日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Column(name = "happen_date",   columnDefinition = "datetime COMMENT '发生日期'")
    private Date happenDate;

    /**
     * 门店编码
     */
    @ApiModelProperty(name = "门店编码", notes = "门店编码", value = "门店编码")
    @Column(name = "terminal_code",  length = 64, columnDefinition = "VARCHAR(64) COMMENT '门店编码'")
    private String terminalCode;

    @ApiModelProperty(name = "门店名称", notes = "门店名称", value = "门店名称")
    @Column(name = "terminal_name",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '门店编码'")
    private String terminalName;


    @ApiModelProperty(name = "扣费名称", notes = "扣费名称")
    @Column(name = "deduction_name",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '扣费名称'")
    private String  deductionName;


    @ApiModelProperty(name = "扣费方式", notes = "扣费方式")
    @Column(name = "deduction_type",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '扣费方式'")
    private String  deductionType;


    @ApiModelProperty(name = "扣费金额不含税", notes = "扣费金额不含税")
    @Column(name = "deduction_amount_no_tax",   columnDefinition = "Decimal(24,6) COMMENT '扣费金额不含税'")
    private BigDecimal deductionAmountNoTax;


    @ApiModelProperty(name = "扣费金额含税", notes = "扣费金额含税")
    @Column(name = "deduction_amount_tax",  columnDefinition = "Decimal(24,6) COMMENT '扣费金额含税'")
    private BigDecimal  deductionAmountTax;

    /**
     * 售达方名称
     */
    @ApiModelProperty("售达方名称/客户名称")
    @Column(name = "customer_name",  length = 255, columnDefinition = "VARCHAR(255) COMMENT '售达方名称/客户名称'")
    private String customerName;

    /**
     * 售达方编码
     */
    @ApiModelProperty("售达方编码/客户mdg编码")
    @Column(name = "customer_epr_code",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '售达方编码/客户mdg编码'")
    private String customerEprCode;

    @ApiModelProperty("业务区域")
    @Column(name = "business_area",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务区域'")
    private String businessArea;

    /**
     * 单据日期
     */
    @ApiModelProperty("单据日期")
    @Column(name = "order_date",  length = 20, columnDefinition = "VARCHAR(20) COMMENT '单据日期'")
    private String orderDate;

    @ApiModelProperty("关联费用单编码")
    @Column(name = "cost_code",  length = 40, columnDefinition = "VARCHAR(40) COMMENT '关联费用单编码'")
    private String costCode;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(name = "业态[数据字典:mdm_business_format]", notes = "")
    @Column(name = "business_format_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '业态[数据字典:mdm_business_format]'")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(name = "业务单元[数据字典:mdm_business_unit]", notes = "")
    @Column(name = "business_unit_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务单元[数据字典:mdm_business_unit]'")
    private String businessUnitCode;

    @ApiModelProperty("零售商编码")
    @Column(name = "system_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '零售商编码'")
    private String systemCode;

    @ApiModelProperty("零售商名称")
    @Column(name = "system_name", length = 255, columnDefinition = "VARCHAR(255) COMMENT '零售商名称'")
    private String systemName;

    @ApiModelProperty("销售组织编码")
    @Column(name = "sales_org_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售组织编码'")
    private String salesOrgCode;

    @ApiModelProperty("销售组织名称")
    @Column(name = "sales_org_name", length = 255, columnDefinition = "VARCHAR(255) COMMENT '销售组织名称'")
    private String salesOrgName;

    @ApiModelProperty("系统编码")
    @Column(name = "direct_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '系统编码'")
    private String directCode;

    /**
     * 商超名称
     */
    @ApiModelProperty("系统名称")
    @Column(name = "supermarket_name", length = 255, columnDefinition = "VARCHAR(255) COMMENT '系统名称'")
    private String supermarketName;

    @ApiModelProperty("关联零售商编码")
    @Column(name = "customer_retailer_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '关联零售商编码'")
    private String customerRetailerCode;

    @ApiModelProperty("关联零售商名称")
    @Column(name = "customer_retailer_name", length = 255, columnDefinition = "VARCHAR(255) COMMENT '关联零售商名称'")
    private String customerRetailerName;

    @ApiModelProperty("扣费明细单据单号")
    @Column(name = "document_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '扣费明细单据单号'")
    private String documentCode;

    @ApiModelProperty("结案形式")
    @Column(name = "audit_way", length = 60, columnDefinition = "VARCHAR(60) COMMENT '结案形式'")
    private String auditWay;

    @ApiModelProperty("兑付方式")
    @Column(name = "cashing_type", length = 60, columnDefinition = "VARCHAR(60) COMMENT '兑付方式'")
    private String cashingType;

    @ApiModelProperty("扣费明细项编码")
    @Column(name = "deduction_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '扣费明细项编码'")
    private String deductionCode;

    /**
     * 结算单号
     */
    @ApiModelProperty("结算单日期")
    @Column(name = "statement_date", length = 20, columnDefinition = "VARCHAR(20) COMMENT '结算单日期'")
    private String statementDate;

}
