package com.biz.crm.tpm.business.audit.fee.local.entity.check;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @author ：dengwei
 * @date ：Created in 2022/12/9 16:55
 * @description：扣费核定
 */
@ApiModel(value = "auditFeeVerifyDecide", description = "扣费核定")
@TableName("tpm_audit_fee_verify_decide")
@Getter
@Setter
@Entity(name = "tpm_audit_fee_verify_decide")
@org.hibernate.annotations.Table(appliesTo = "tpm_audit_fee_verify_decide", comment = "扣费核定")
@Table(name = "tpm_audit_fee_verify_decide",
        indexes = {@Index(name = "tpm_audit_fee_verify_decide_index1", columnList = "activity_detail_code", unique = false),
                @Index(name = "tpm_audit_fee_verify_decide_index2", columnList = "activity_detail_item_code", unique = false)
})
public class AuditFeeVerifyDecide extends TenantFlagOpEntity {

    @ApiModelProperty("活动细案编码")
    @Column(name = "activity_detail_code",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动细案编码'")
    private String activityDetailCode;

    @ApiModelProperty("活动细案名称")
    @Column(name = "activity_detail_name",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '活动细案名称'")
    private String activityDetailName;

    @ApiModelProperty("活动细案明细编码")
    @Column(name = "activity_detail_item_code",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动细案明细编码'")
    private String activityDetailItemCode;

    @ApiModelProperty("活动细案明细名称")
    @Column(name = "activity_detail_item_name",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '活动细案明细名称'")
    private String activityDetailItemName;

    @ApiModelProperty("门店编码")
    @Column(name = "terminal_code",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '门店编码'")
    private String terminalCode;

    @ApiModelProperty("门店名称")
    @Column(name = "terminal_name",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '门店名称'")
    private String terminalName;

    @ApiModelProperty("产品编码")
    @Column(name = "product_code",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '产品编码'")
    private String productCode;

    @ApiModelProperty("产品名称")
    @Column(name = "product_name",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '产品名称'")
    private String productName;

    @ApiModelProperty(name = "customerCode", value = "客户编码")
    @Column(name = "customer_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '客户编码'")
    private String customerCode;

    @ApiModelProperty(name = "customerName", value = "客户名称")
    @Column(name = "customer_name",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '客户名称'")
    private String customerName;

    @ApiModelProperty("费用核对编码")
    @Column(name = "audit_fee_check_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '费用核对编码'")
    private String auditFeeCheckCode;

    @ApiModelProperty("业态")
    @Column(name = "business_format_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '业态'")
    private String businessFormatCode;

    @ApiModelProperty("业务单元")
    @Column(name = "business_unit_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '业务单元'")
    private String businessUnitCode;

    @ApiModelProperty("零售商区域编码")
    @Column(name = "area_code",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '零售商区域编码'")
    private String areaCode;

    @ApiModelProperty(name = "销售机构编码", notes = "销售机构编码")
    @Column(name = "sales_institution_code",  length = 32, columnDefinition = "VARCHAR(128) COMMENT '销售机构编码'")
    private String salesInstitutionCode;

    @ApiModelProperty(name = "销售机构ERP编码", notes = "销售机构ERP编码")
    @Column(name = "sales_institution_erp_code",  length = 32, columnDefinition = "VARCHAR(128) COMMENT '销售机构ERP编码'")
    private String salesInstitutionErpCode;

    @ApiModelProperty(name = "销售机构名称", notes = "销售机构名称")
    @Column(name = "sales_institution_name",  length = 256, columnDefinition = "VARCHAR(256) COMMENT '销售机构名称'")
    private String salesInstitutionName;

    @ApiModelProperty("关联零售商编码")
    @Column(name = "customer_retailer_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '关联零售商编码'")
    private String customerRetailerCode;

    @ApiModelProperty("关联零售商名称")
    @Column(name = "customer_retailer_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '关联零售商名称'")
    private String customerRetailerName;

    @ApiModelProperty("核销明细编号")
    @Column(name = "audit_detail_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '核销明细编号 '")
    private String auditDetailCode;

    @ApiModelProperty("核销编号")
    @Column(name = "audit_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '核销编号 '")
    private String auditCode;

    @ApiModelProperty("是否下推结案核销 0为未推送，1为推送成功，-1为推送失败")
    @Column(name = "is_push",  length = 2, columnDefinition = "char(2) COMMENT '是否下推结案核销，0为未推送，1为推送成功，-1为推送失败'")
    private String isPush;

    @ApiModelProperty("是否完全结案")
    @Column(name = "whole_audit", length = 10, columnDefinition = "VARCHAR(10) COMMENT '是否完全结案'")
    private String wholeAudit;

    @ApiModelProperty("结案形式")
    @Column(name = "audit_way", length = 60, columnDefinition = "VARCHAR(60) COMMENT '结案形式'")
    private String auditWay;

    @ApiModelProperty("来源 1为费用核对管理 2结算核对管理")
    @Column(name = "source", length = 1, columnDefinition = "VARCHAR(1) COMMENT '来源 1为费用核对管理 2结算核对管理'")
    private String source;

    @ApiModelProperty("核准金额")
    @Column(name = "verify_decide_amount", columnDefinition = "decimal(24,6) COMMENT '核准金额'")
    private BigDecimal verifyDecideAmount;

    @ApiModelProperty(name = "activityYearMonth", value = "活动年月")
    @Column(name = "activity_year_month", columnDefinition = "VARCHAR(32) COMMENT '活动年月'")
    private String activityYearMonth;

    @ApiModelProperty(name = "feeYearMonth", value = "费用年月")
    @Column(name = "fee_year_month", columnDefinition = "VARCHAR(32) COMMENT '费用年月'")
    private String feeYearMonth;
}

