package com.biz.crm.tpm.business.audit.fee.local.entity.dispose;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import liquibase.pro.packaged.S;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author ：dengwei
 * @date ：Created in 2022/12/9 16:55
 * @description：核销差异费用处理
 */
@ApiModel(value = "AuditFeeDiffDispose", description = "核销差异费用处理")
@TableName("tpm_audit_fee_diff_dispose")
@Getter
@Setter
@Entity(name = "tpm_audit_fee_diff_dispose")
@org.hibernate.annotations.Table(appliesTo = "tpm_audit_fee_diff_dispose", comment = "核销差异费用处理")
@Table(name = "tpm_audit_fee_diff_dispose")
public class AuditFeeDiffDispose extends TenantFlagOpEntity {

    /**
     * 差异费用处理编码
     */
    @ApiModelProperty(name = "feeDiffDisposeCode", notes = "差异费用处理编码")
    @Column(name = "fee_diff_dispose_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '差异费用处理编码'")
    private String feeDiffDisposeCode;



    /**
     * 差异费用处理名称
     */
    @ApiModelProperty(name = "feeDiffDisposeName", notes = "差异费用处理名称")
    @Column(name = "fee_diff_dispose_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '差异费用处理名称'")
    private String feeDiffDisposeName;

    /**
     * 审批状态
     */
    @ApiModelProperty(name = "processStatus",value = "审批状态",notes = "审批状态")
    @Column(name = "process_status", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '审批状态 '")
    private String processStatus;


    /**
     * 处理方式
     */
    @ApiModelProperty(name = "handling",value = "处理方式",notes = "处理方式")
    @Column(name = "handling", length = 32, columnDefinition = "VARCHAR(32) COMMENT '处理方式 '")
    private String  handling;


    /**
     * 是否核销
     */
    @ApiModelProperty(name = "isAudit", notes = "是否核销")
    @Column(name = "is_audit",  length = 10, columnDefinition = "VARCHAR(10) COMMENT '是否核销 '")
    private String isAudit;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(name = "businessFormatCode", notes = "业态[数据字典:mdm_business_format]")
    @Column(name = "business_format_code",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '业态[数据字典:mdm_business_format] '")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(name = "businessUnitCode", notes = "业务单元[数据字典:mdm_business_unit]")
    @Column(name = "business_unit_code",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务单元[数据字典:mdm_business_unit] '")
    private String businessUnitCode;


    /**
     * 处理费用金
     */
    @ApiModelProperty(name = "disposeFeeAmount", notes = "处理费用金")
    @Column(name = "dispose_fee_amount",  columnDefinition = "Decimal(24,6) COMMENT '处理费用金 '")
    private BigDecimal disposeFeeAmount;

    /**
     * 差异费用处理说明
     */
    @ApiModelProperty(name = "diffFeeDisposeIllustrate", notes = "差异费用处理说明")
    @Column(name = "diff_fee_dispose_illustrate",  columnDefinition = "VARCHAR(255) COMMENT '差异费用处理说明 '")
    private String diffFeeDisposeIllustrate;

    @ApiModelProperty("来源")
    @Column(name = "where_from", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '来源'")
    private String whereFrom;

    @ApiModelProperty("活动模版编码")
    @Column(name = "template_codes", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '活动模版编码'")
    private String templateCodes;

    @ApiModelProperty("流程编码")
    @Column(name = "process_no", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '流程编码'")
    private String processNo;

    @ApiModelProperty(name = "扣费匹配单号", notes = "扣费匹配单号")
    @Column(name = "match_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '扣费匹配单号'")
    private String matchCode;
}
