package com.biz.crm.tpm.business.audit.fee.local.entity.dispose;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author ：dengwei
 * @date ：Created in 2022/12/9 16:55
 * @description：核销差异费用处理明细
 */
@ApiModel(value = "AuditFeeDiffDisposeDetail", description = "核销差异费用处理明细")
@TableName("tpm_audit_fee_diff_dispose_detail")
@Getter
@Setter
@Entity(name = "tpm_audit_fee_diff_dispose_detail")
@org.hibernate.annotations.Table(appliesTo = "tpm_audit_fee_diff_dispose_detail", comment = "核销差异费用处理明细")
@Table(name = "tpm_audit_fee_diff_dispose_detail")
public class AuditFeeDiffDisposeDetail extends TenantFlagOpEntity {

    /**
     * 差异费用处理编码
     */
    @ApiModelProperty(name = "feeDiffDisposeCode", notes = "差异费用处理编码")
    @Column(name = "fee_diff_dispose_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '差异费用处理编码'")
    private String feeDiffDisposeCode;

    /**
     * 差异费用处理名称
     */
    @ApiModelProperty(name = "feeDiffDisposeName", notes = "差异费用处理名称")
    @Column(name = "fee_diff_dispose_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '差异费用处理名称'")
    private String feeDiffDisposeName;

    /**
     * 活动模板编码
     */
    @ApiModelProperty("活动模板编码")
    @Column(name = "template_config_code", length = 32, columnDefinition = "varchar(32) COMMENT '活动模板编码'")
    private String templateConfigCode;

    /**
     * 活动模板名称
     */
    @Column(name = "template_config_name", length = 128, columnDefinition = "varchar(128) COMMENT '活动模板名称'")
    private String templateConfigName;

    /**
     * 明细编码
     */
    @ApiModelProperty("明细编码")
    @Column(name = "detail_plan_item_code", length = 32, columnDefinition = "varchar(32) COMMENT '明细编码'")
    private String detailPlanItemCode;

    @ApiModelProperty("推送牛人管家状态标记")
    @Column(name = "cow_manager_state", length = 2, columnDefinition = "VARCHAR(2) COMMENT '推送牛人管家标记'")
    private String cowManagerState;

    /**
     * 活动类型编码
     */
    @ApiModelProperty("活动类型编码")
    @Column(name = "activity_type_code", length = 32, columnDefinition = "varchar(32) COMMENT '活动类型编码'")
    private String activityTypeCode;
    /**
     * 活动类型名称
     */
    @ApiModelProperty("活动类型名称")
    @Column(name = "activity_type_name", length = 128, columnDefinition = "varchar(128) COMMENT '活动类型名称'")
    private String activityTypeName;

    /**
     * 活动形式编码
     */
    @ApiModelProperty("活动形式编码")
    @Column(name = "activity_form_code", length = 32, columnDefinition = "varchar(32) COMMENT '活动形式编码'")
    private String activityFormCode;

    /**
     * 活动形式名称
     */
    @ApiModelProperty("活动形式名称")
    @Column(name = "activity_form_name", length = 128, columnDefinition = "varchar(128) COMMENT '活动形式名称'")
    private String activityFormName;

    /**
     * 购买方式
     */
    @ApiModelProperty("购买方式")
    @Column(name = "buy_way", length = 32, columnDefinition = "varchar(32) COMMENT '购买方式'")
    private String buyWay;

    /**
     * 活动开始时间
     */
    @ApiModelProperty("活动开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "activity_begin_date", columnDefinition = "datetime COMMENT '活动开始时间'")
    private Date activityBeginDate;

    /**
     * 活动结束时间
     */
    @ApiModelProperty("活动结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "activity_end_date",  columnDefinition = "datetime COMMENT '活动结束时间'")
    private Date activityEndDate;

    /**
     * 费用所属年月
     */
    @ApiModelProperty("费用所属年月")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    @Column(name = "fee_year_month", length = 20, columnDefinition = "datetime COMMENT '费用所属年月 '")
    private Date feeYearMonth;

    /**
     * 销售组织
     */
    @ApiModelProperty("销售组织编码")
    @Column(name = "activity_org_code", length = 32, columnDefinition = "varchar(32) COMMENT '销售组织编码'")
    private String activityOrgCode;
    /**
     * 销售组织名称
     */
    @ApiModelProperty("销售组织名称")
    @Column(name = "activity_org_name", length = 128, columnDefinition = "varchar(128) COMMENT '销售组织名称'")
    private String activityOrgName;

    /**
     * 系统
     */
    @ApiModelProperty("零售商编码")
    @Column(name = "system_code", length = 32, columnDefinition = "varchar(32) COMMENT '零售商编码'")
    private String systemCode;
    /**
     * 系统
     */
    @ApiModelProperty("零售商名称")
    @Column(name = "system_name", length = 128, columnDefinition = "varchar(128) COMMENT '零售商名称'")
    private String systemName;

    /**
     * 客户编码
     */
    @ApiModelProperty("客户编码")
    @Column(name = "customer_code", length = 255, columnDefinition = "varchar(255) COMMENT '客户编码'")
    private String customerCode;

    /**
     * 客户名称
     */
    @ApiModelProperty("客户名称")
    @Column(name = "customer_name", length = 255, columnDefinition = "varchar(255) COMMENT '客户名称'")
    private String customerName;

    /**
     * AC门店类型
     */
    @ApiModelProperty("AC门店类型")
    @Column(name = "ac_store_type", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT 'AC门店类型'")
    private String acStoreType;

    /**
     * 门店编码
     */
    @ApiModelProperty("门店编码")
    @Column(name = "terminal_code", length = 255, columnDefinition = "varchar(255) COMMENT '门店编码'")
    private String terminalCode;

    /**
     * 门店名称
     */
    @ApiModelProperty("门店名称")
    @Column(name = "terminal_name", length = 255, columnDefinition = "varchar(255) COMMENT '门店名称'")
    private String terminalName;

    /**
     * 品牌编码
     */
    @ApiModelProperty("品牌编码")
    @Column(name = "product_brand_code", length = 32, columnDefinition = "varchar(32) COMMENT '品牌编码'")
    private String productBrandCode;
    /**
     * 品牌名称
     */
    @ApiModelProperty("品牌名称")
    @Column(name = "product_brand_name", length = 255, columnDefinition = "varchar(255) COMMENT '品牌名称'")
    private String productBrandName;
    /**
     * 品类编码
     */
    @ApiModelProperty("品类编码")
    @Column(name = "product_category_code", length = 32, columnDefinition = "varchar(32) COMMENT '品类编码'")
    private String productCategoryCode;
    /**
     * 品类名称
     */
    @ApiModelProperty("品类名称")
    @Column(name = "product_category_name", length = 255, columnDefinition = "varchar(255) COMMENT '品类名称'")
    private String productCategoryName;
    /**
     * 品项编码
     */
    @ApiModelProperty("品项编码")
    @Column(name = "product_item_code", length = 32, columnDefinition = "varchar(32) COMMENT '品项编码'")
    private String productItemCode;
    /**
     * 品项名称
     */
    @ApiModelProperty("品项名称")
    @Column(name = "product_item_name", length = 255, columnDefinition = "varchar(255) COMMENT '品项名称'")
    private String productItemName;
    /**
     * 产品编码
     */
    @ApiModelProperty("产品编码")
    @Column(name = "product_code", length = 32, columnDefinition = "varchar(32) COMMENT '产品编码'")
    private String productCode;
    /**
     * 产品名称
     */
    @ApiModelProperty("产品名称")
    @Column(name = "product_name", length = 255, columnDefinition = "varchar(255) COMMENT '产品名称'")
    private String productName;

    /**
     * 单价（陈列单价）
     */
    @ApiModelProperty("单价")
    @Column(name = "price", length = 32, columnDefinition = "varchar(32) COMMENT '陈列类型'")
    private BigDecimal price;

    /**
     * 数量（陈列数量）
     */
    @ApiModelProperty("数量")
    @Column(name = "quantity", length = 11, columnDefinition = "int(11) COMMENT '数量'")
    private Integer quantity;

    /**
     * 费用合计
     */
    @ApiModelProperty("费用合计")
    @Column(name = "total_fee_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '费用合计'")
    private BigDecimal totalFeeAmount;

    /**
     * 差异费用台帐编码
     */
    @ApiModelProperty(name = "feeDiffLedgerCode", notes = "差异费用台帐编码")
    @Column(name = "fee_diff_ledger_code", length = 128, columnDefinition = "varchar(128) COMMENT '差异费用台帐编码'")
    private String feeDiffLedgerCode;

    /**
     * 差异费用
     */
    @ApiModelProperty("差异费用")
    @Column(name = "this_use_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '差异费用'")
    private BigDecimal thisUseAmount;

    /**
     * 投产比
     */
    @ApiModelProperty("投产比")
    @Column(name = "production_ratio", length = 32, columnDefinition = "decimal(24,6) COMMENT '投产比'")
    private BigDecimal productionRatio;

    /**
     * 月度计划量
     */
    @ApiModelProperty("月度计划量")
    @Column(name = "monthly_planned_quantity", length = 32, columnDefinition = "int(11) COMMENT '月度计划量'")
    private BigDecimal monthlyPlannedQuantity;

    /**
     * 核销类型
     */
    @ApiModelProperty("核销类型")
    @Column(name = "audit_type", length = 30, columnDefinition = "varchar(30) COMMENT '核销类型'")
    private String auditType;

    /**
     * 核销条件编码
     */
    @ApiModelProperty("核销条件编码")
    @Column(name = "audit_condition_code", length = 32, columnDefinition = "varchar(32) COMMENT '核销条件编码'")
    private String auditConditionCode;
    /**
     * 核销条件名称
     */
    @ApiModelProperty("核销条件名称")
    @Column(name = "audit_condition_name", length = 255, columnDefinition = "varchar(255) COMMENT '核销条件名称'")
    private String auditConditionName;

    /**
     * 活动描述
     */
    @ApiModelProperty("活动描述")
    @Column(name = "activity_desc", length = 255, columnDefinition = "varchar(1024) COMMENT '活动描述'")
    private String activityDesc;

    /**
     * 是否档期
     */
    @ApiModelProperty("是否档期")
    @Column(name = "on_schedule_or_not", length = 32, columnDefinition = "varchar(32) COMMENT '是否档期'")
    private String onScheduleOrNot;

    /**
     * 档期时间
     */
    @ApiModelProperty("档期时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    @Column(name = "schedule_time", length = 20, columnDefinition = "datetime COMMENT '档期时间 '")
    private Date scheduleTime;

    /**
     * 本次结案金额
     */
    @ApiModelProperty(name = "thisSettlementAmount", notes = "本次结案金额")
    @Column(name = "this_settlement_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '本次结案金额'")
    private BigDecimal thisSettlementAmount;

    /**
     * 是否完全结案(枚举[BooleanEnum]字典[yesOrNo])
     */
    @ApiModelProperty(name = "allSettlement", notes = "是否完全结案(枚举[BooleanEnum]字典[yesOrNo])")
    @Column(name = "all_settlement",length = 32, columnDefinition = "varchar(32) COMMENT '是否完全结案(枚举[BooleanEnum]字典[yesOrNo])'")
    private String allSettlement;
}
