package com.biz.crm.tpm.business.audit.fee.local.entity.dispose;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author ：dengwei
 * @date ：Created in 2022/12/9 16:55
 * @description：核销差异费用处理
 */
@ApiModel(value = "AuditFeeDiffDisposeLedger", description = "核销差异费用处理预算汇总信息")
@TableName("tpm_audit_fee_diff_dispose_ledger")
@Getter
@Setter
@Entity(name = "tpm_audit_fee_diff_dispose_ledger")
@org.hibernate.annotations.Table(appliesTo = "tpm_audit_fee_diff_dispose_ledger", comment = "核销差异费用处理预算汇总信息")
@Table(name = "tpm_audit_fee_diff_dispose_ledger")
public class AuditFeeDiffDisposeLedger extends TenantFlagOpEntity {

    /**
     * 差异费用处理编码
     */
    @ApiModelProperty(name = "feeDiffDisposeCode", notes = "差异费用处理编码")
    @Column(name = "fee_diff_dispose_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '差异费用处理编码'")
    private String feeDiffDisposeCode;

    /**
     * 差异费用处理名称
     */
    @ApiModelProperty(name = "feeDiffDisposeName", notes = "差异费用处理名称")
    @Column(name = "fee_diff_dispose_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '差异费用处理名称'")
    private String feeDiffDisposeName;

    /**
     * 差异费用台帐编码
     */
    @ApiModelProperty(name = "feeDiffLedgerCode", notes = "差异费用台帐编码")
    @Column(name = "fee_diff_ledger_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '差异费用台帐编码'")
    private String feeDiffLedgerCode;

    /**
     * 费用所属年月
     */
    @ApiModelProperty("费用所属年月")
    @Column(name = "fee_year_month", length = 20, columnDefinition = "VARCHAR(8) COMMENT '费用所属年月 '")
    private String feeYearMonth;

    @ApiModelProperty(name = "beRecoveredAmount", notes = "待追回金额", value = "待追回金额")
    @Column(name = "be_recovered_amount",  columnDefinition = "decimal(24,6) COMMENT '待追回金额'")
    private BigDecimal beRecoveredAmount;

    @ApiModelProperty(name = "本次使用金额", notes = "本次使用金额")
    @Column(name = "this_use_amount",  length = 128, columnDefinition = "decimal(24,6) COMMENT '本次使用金额'")
    private BigDecimal thisUseAmount;





}
