package com.biz.crm.tpm.business.audit.fee.local.entity.dispose;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author ：dengwei
 * @date ：Created in 2022/12/9 16:55
 * @description：核销差异费用处理
 */
@ApiModel(value = "AuditFeeDiffDisposeLedgerItem", description = "核销差异费用处理关联台帐明细")
@TableName("tpm_audit_fee_diff_dispose_ledger_item")
@Getter
@Setter
@Entity(name = "tpm_audit_fee_diff_dispose_ledger_item")
@org.hibernate.annotations.Table(appliesTo = "tpm_audit_fee_diff_dispose_ledger_item", comment = "核销差异费用处理关联台帐明细")
@Table(name = "tpm_audit_fee_diff_dispose_ledger_item")
public class AuditFeeDiffDisposeLedgerItem extends TenantFlagOpEntity {

    /**
     * 差异费用处理编码
     */
    @ApiModelProperty(name = "feeDiffDisposeCode", notes = "差异费用处理编码")
    @Column(name = "fee_diff_dispose_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '差异费用处理编码'")
    private String feeDiffDisposeCode;

    /**
     * 明细编码
     */
    @ApiModelProperty("明细编码")
    @Column(name = "detail_plan_item_code", length = 32, columnDefinition = "varchar(32) COMMENT '明细编码'")
    private String detailPlanItemCode;

    /**
     * 差异费用台帐编码
     */
    @ApiModelProperty(name = "feeDiffLedgerCode", notes = "差异费用台帐编码")
    @Column(name = "fee_diff_ledger_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '差异费用台帐编码'")
    private String feeDiffLedgerCode;

    /**
     * 费用所属年月
     */
    @ApiModelProperty("费用所属年月")
    @Column(name = "fee_year_month", length = 20, columnDefinition = "VARCHAR(8) COMMENT '费用所属年月 '")
    private String feeYearMonth;

    @ApiModelProperty(name = "本次使用金额", notes = "本次使用金额")
    @Column(name = "this_use_amount",  length = 128, columnDefinition = "decimal(24,6) COMMENT '本次使用金额'")
    private BigDecimal thisUseAmount;

    @ApiModelProperty(name = "businessFormatCode", notes = "业态")
    @Column(name = "business_format_code", length = 128, columnDefinition = "VARCHAR(128) COMMENT '业态'")
    private String businessFormatCode;


    @ApiModelProperty(name = "businessUnitCode", notes = "业务单元")
    @Column(name = "business_unit_code", length = 128, columnDefinition = "VARCHAR(128) COMMENT '业务单元'")
    private String businessUnitCode;

    @ApiModelProperty(name = "diffAmount", notes = "差异金额", value = "差异金额")
    @Column(name = "diff_amount",  columnDefinition = "decimal(24,6) COMMENT '差异金额'")
    private BigDecimal diffAmount;

    @ApiModelProperty(name = "recoveredAmount", notes = "已追回金额", value = "已追回金额")
    @Column(name = "recovered_amount",  columnDefinition = "decimal(24,6) COMMENT '已追回金额'")
    private BigDecimal recoveredAmount;

    @ApiModelProperty(name = "beRecoveredAmount", notes = "待追回金额", value = "待追回金额")
    @Column(name = "be_recovered_amount",  columnDefinition = "decimal(24,6) COMMENT '待追回金额'")
    private BigDecimal beRecoveredAmount;

}
