package com.biz.crm.tpm.business.audit.fee.local.entity.ledger;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author ：dengwei
 * @date ：Created in 2022/12/9 16:55
 * @description：扣费核定
 */
@ApiModel(value = "AuditFeeDiffLedgerDeduction", description = "核销差异费用扣减明细")
@TableName("tpm_audit_fee_diff_ledger_deduction")
@Getter
@Setter
@Entity(name = "tpm_audit_fee_diff_ledger_deduction")
@org.hibernate.annotations.Table(appliesTo = "tpm_audit_fee_diff_ledger_deduction", comment = "核销差异费用扣减明细")
@Table(name = "tpm_audit_fee_diff_ledger_deduction", indexes = {
        @Index(name = "tpm_audit_fee_diff_ledger_deduction_idx1", columnList = "fee_diff_ledger_Code", unique = false)
})
public class AuditFeeDiffLedgerDeduction extends TenantFlagOpEntity {

    /**
     * 差异费用台账编码
     */
    @ApiModelProperty(name = "feeDiffLedgerCode", notes = "差异费用台账编码")
    @Column(name = "fee_diff_ledger_Code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '差异费用台账编码'")
    private String feeDiffLedgerCode;

    /**
     * 操作类型[audit_fee_diff_ledger_operation_type]
     */
    @ApiModelProperty(value = "操作类型[audit_fee_diff_ledger_operation_type]", notes = "")
    @Column(name = "operation_type", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '操作类型 '")
    private String operationType;

    /**
     * 差异费用处理明细编码
     */
    @ApiModelProperty(name = "businessCode", notes = "业务编码")
    @Column(name = "business_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '业务编码'")
    private String businessCode;

    /**
     * 差异费用处理编码
     */
    @ApiModelProperty(name = "feeDiffLedgerDisposeCode", notes = "差异费用处理编码")
    @Column(name = "fee_diff_ledger_dispose_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '差异费用处理编码'")
    private String feeDiffLedgerDisposeCode;

    @ApiModelProperty(name = "活动形式Code", notes = "活动形式Code")
    @Column(name = "activity_form_code",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动形式Code'")
    private String activityFormCode;

    @ApiModelProperty(name = "活动形式名称", notes = "活动形式名称")
    @Column(name = "activity_form_name",  length = 255, columnDefinition = "VARCHAR(255) COMMENT '活动形式名称'")
    private String activityFormName;

    @ApiModelProperty(name = "活动分类Code", notes = "活动分类Code")
    @Column(name = "activity_type_code",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动分类Code'")
    private String activityTypeCode;

    @ApiModelProperty(name = "活动分类名称", notes = "活动分类名称")
    @Column(name = "activity_type_name",  length = 255, columnDefinition = "VARCHAR(255) COMMENT '活动分类名称'")
    private String activityTypeName;


    /**
     * 零售商
     */
    @ApiModelProperty(name = "零售商", notes = "零售商")
    @Column(name = "resale_commercial_code", length = 32,columnDefinition = "VARCHAR(32) COMMENT '零售商'")
    private String resaleCommercialCode;

    /**
     * 零售商名称
     */
    @ApiModelProperty(name = "零售商名称", notes = "零售商名称")
    @Column(name = "resale_commercial_name", columnDefinition = "VARCHAR(255) COMMENT '零售商名称'")
    private String resaleCommercialName;


    /**
     * 操作金额
     */
    @ApiModelProperty(name = "recoveredAmount", notes = "操作金额", value = "操作金额")
    @Column(name = "recovered_amount", columnDefinition = "Decimal(24,6) COMMENT '操作金额 '")
    private BigDecimal recoveredAmount;

    /**
     * 操作人账号
     */
    @ApiModelProperty(name = "操作人账号", notes = "操作人账号")
    @Column(name = "operator_account",length = 64, columnDefinition = "VARCHAR(64) COMMENT '操作人账号'")
    private String operatorAccount;

    /**
     * 操作人名称
     */
    @ApiModelProperty(name = "操作人名称", notes = "操作人名称")
    @Column(name = "operator_name",length = 128, columnDefinition = "VARCHAR(128) COMMENT '操作人名称'")
    private String operatorName;

    /**
     * 操作时间
     */
    @ApiModelProperty(name = "recoveredTime", notes = "操作时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @Column(name = "recovered_time",  columnDefinition = "datetime COMMENT '操作时间(yyyy-MM-dd HH:mm:ss)'")
    private Date recoveredTime;


    @ApiModelProperty(name = "门店编码", notes = "门店编码")
    @Column(name = "terminal_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '门店编码'")
    private String terminalCode;

    /**
     * 门店名称
     */
    @ApiModelProperty(name = "门店名称", notes = "门店名称")
    @Column(name = "terminal_name", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '门店名称'")
    private String terminalName;

    @ApiModelProperty(name = "数据来源", notes = "数据来源")
    @Column(name = "data_source", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '数据来源'")
    private String dataSource;
}
