package com.biz.crm.tpm.business.audit.fee.local.entity.ledger;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author ：dengwei
 * @date ：Created in 2022/12/9 16:55
 * @description：扣费核定
 */
@ApiModel(value = "AuditFeeDiffLedgerPlan", description = "核销差异费用台账计划明细")
@TableName("tpm_audit_fee_diff_ledger_plan")
@Getter
@Setter
@Entity(name = "tpm_audit_fee_diff_ledger_plan")
@org.hibernate.annotations.Table(appliesTo = "tpm_audit_fee_diff_ledger_plan", comment = "核销差异费用台账计划明细")
@Table(name = "tpm_audit_fee_diff_ledger_plan")
public class AuditFeeDiffLedgerPlan extends TenantFlagOpEntity {

    /**
     * 差异费用台账关联id
     */
    @ApiModelProperty(name = "fee_diff_ledger_id", notes = "差异费用台账关联id")
    @Column(name = "fee_diff_ledger_id", length = 64, columnDefinition = "VARCHAR(64) COMMENT '差异费用台账关联id'")
    private String feeDiffLedgerId;

    @ApiModelProperty(name = "feeDiffLedgerCode", notes = "差异费用台帐编码")
    @Column(name = "fee_diff_ledger_code", length = 128, columnDefinition = "VARCHAR(128) COMMENT '差异费用台帐编码'")
    private String feeDiffLedgerCode;

    /**
     * 完全追回时间
     */
    @ApiModelProperty(name = "recoveredTime", notes = "计划追回时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @Column(name = "plan_recovered_time",  columnDefinition = "datetime COMMENT '计划追回时间(yyyy-MM-dd)'")
    private Date planRecoveredTime;

    @ApiModelProperty(name = "活动形式Code", notes = "活动形式Code")
    @Column(name = "activity_form_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '活动形式Code'")
    private String activityFormCode;


    @ApiModelProperty(name = "活动形式名称", notes = "活动形式名称")
    @Column(name = "activity_form_name",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '活动形式名称'")
    private String activityFormName;


    /**
     * 计划追回金额
     */
    @ApiModelProperty(name = "planRecoveredAmount", notes = "计划追回金额", value = "计划追回金额")
    @Column(name = "plan_recovered_amount", columnDefinition = "Decimal(24,6) COMMENT '计划追回金额 '")
    private BigDecimal planRecoveredAmount;

    /**
     * 待追回金额
     */
    @ApiModelProperty(name = "recoveredAmount", notes = "已追回金额", value = "已追回金额")
    @Column(name = "recovered_amount", columnDefinition = "Decimal(24,6) COMMENT '已追回金额 '")
    private BigDecimal recoveredAmount;

    /**
     * 待追回金额
     */
    @ApiModelProperty(name = "beRecoveredAmount", notes = "待追回金额", value = "待追回金额")
    @Column(name = "be_recovered_amount", columnDefinition = "Decimal(24,6) COMMENT '待追回金额 '")
    private BigDecimal beRecoveredAmount;

    @ApiModelProperty(name = "排期进度", notes = "排期进度")
    @Column(name = "schedule_progress",  columnDefinition = "Decimal(8,6) COMMENT '排期进度'")
    private BigDecimal scheduleProgress;

    @ApiModelProperty(name = "完成进度", notes = "完成进度")
    @Column(name = "complete_progress",  columnDefinition = "Decimal(8,6) COMMENT '完成进度'")
    private BigDecimal completeProgress;

    /**
     * 序号
     */
    @ApiModelProperty(value = "序号", notes = "")
    @Column(name = "serial_number", nullable = true, length = 26, columnDefinition = "int(26) COMMENT '序号'")
    private Integer serialNumber;
}
