package com.biz.crm.tpm.business.audit.fee.local.entity.prediction;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Description:扣费预测
 * @Author zy
 * @Date 2023/9/23
 */
@Data
@TableName("tpm_audit_fee_prediction")
@Entity(name = "tpm_audit_fee_prediction")
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "AuditFeeCostPrediction", description = "TPM-扣费预测管理")
@org.hibernate.annotations.Table(appliesTo = "tpm_audit_fee_prediction", comment = "TPM-扣费预测管理")
@Table(name = "tpm_audit_fee_prediction", indexes = {@Index(name = "tpm_audit_fee_cost_index1", columnList = "del_flag,tenant_code,detail_plan_item_code", unique = true)})
public class AuditFeePrediction extends TenantFlagOpEntity {

    /**
     * 活动细案明细编码
     */
    @ApiModelProperty("活动细案明细编码")
    @TableField(value = "detail_plan_item_code")
    @Column(name = "detail_plan_item_code", length = 64, columnDefinition = "varchar(64) COMMENT '活动细案明细编码'")
    private String detailPlanItemCode;

    /**
     * 活动细案编码
     */
    @ApiModelProperty("活动细案编码")
    @Column(name = "detail_plan_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '活动细案编码'")
    private String detailPlanCode;

    /**
     * 活动细案名称
     */
    @ApiModelProperty("活动细案名称")
    @Column(name = "detail_plan_name", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '活动细案名称'")
    private String detailPlanName;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(name = "业态[数据字典:mdm_business_format]", notes = "业态[数据字典:mdm_business_format]")
    @Column(name = "business_format_code", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业态[数据字典:mdm_business_format] '")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(name = "业务单元[数据字典:mdm_business_unit]", notes = "业务单元[数据字典:mdm_business_unit]")
    @Column(name = "business_unit_code", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务单元[数据字典:mdm_business_unit] '")
    private String businessUnitCode;

    /**
     * 所属销售机构编码
     */
    @ApiModelProperty("所属销售机构编码")
    @Column(name = "sales_institution_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '所属销售机构编码'")
    private String salesInstitutionCode;

    /**
     * 所属销售机构
     */
    @ApiModelProperty("所属销售机构")
    @Column(name = "sales_institution_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '所属销售机构'")
    private String salesInstitutionName;

    /**
     * 零售商编码
     */
    @ApiModelProperty("零售商编码")
    @Column(name = "system_code", length = 32, columnDefinition = "varchar(32) COMMENT '零售商编码'")
    private String systemCode;

    /**
     * 零售商名称
     */
    @ApiModelProperty("零售商名称")
    @Column(name = "system_name", length = 200, columnDefinition = "varchar(200) COMMENT '零售商名称'")
    private String systemName;

    /**
     * 区域
     */
    @ApiModelProperty("区域")
    @Column(name = "region", length = 32, columnDefinition = "varchar(32) COMMENT '区域'")
    private String region;

    /**
     * 活动开始时间
     */
    @ApiModelProperty("活动开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "activity_begin_date", columnDefinition = "datetime COMMENT '活动开始时间'")
    private Date activityBeginDate;

    /**
     * 活动结束时间
     */
    @ApiModelProperty("活动结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "activity_end_date",  columnDefinition = "datetime COMMENT '活动结束时间'")
    private Date activityEndDate;

    /**
     * 订单开始时间
     */
    @ApiModelProperty("订单开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "order_begin_date",  columnDefinition = "datetime COMMENT '活动结束时间'")
    private Date orderBeginDate;

    /**
     * 订单结束时间
     */
    @ApiModelProperty("订单结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "order_end_date",  columnDefinition = "datetime COMMENT '活动结束时间'")
    private Date orderEndDate;

    /**
     * 活动年月（取活动开始时间年月）
     */
    @ApiModelProperty("活动年月")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    @Column(name = "activity_year_month",  columnDefinition = "datetime COMMENT '活动年月'")
    private Date activityYearMonth;

    /**
     * 活动类型编码
     */
    @ApiModelProperty("活动类型编码")
    @Column(name = "activity_type_code", length = 255, columnDefinition = "varchar(255) COMMENT '活动类型编码'")
    private String activityTypeCode;

    /**
     * 活动类型名称
     */
    @ApiModelProperty("活动类型名称")
    @Column(name = "activity_type_name", length = 255, columnDefinition = "varchar(255) COMMENT '活动类型名称'")
    private String activityTypeName;

    /**
     * 活动形式编码
     */
    @ApiModelProperty("活动形式编码")
    @Column(name = "activity_form_code", length = 255, columnDefinition = "varchar(255) COMMENT '活动形式编码'")
    private String activityFormCode;

    /**
     * 活动形式名称
     */
    @ApiModelProperty("活动形式名称")
    @Column(name = "activity_form_name", length = 255, columnDefinition = "varchar(255) COMMENT '活动形式名称'")
    private String activityFormName;

    @ApiModelProperty("活动形式说明")
    @Column(name = "activity_form_desc", columnDefinition = "text COMMENT '活动形式说明'")
    private String activityFormDesc;

    /**
     * 结案形式
     */
    @ApiModelProperty("结案形式")
    @Column(name = "audit_form", length = 32, columnDefinition = "varchar(32) COMMENT '结案形式'")
    private String auditForm;

    /**
     * 购买方式
     */
    @ApiModelProperty("购买方式")
    @Column(name = "buy_way", length = 32, columnDefinition = "varchar(32) COMMENT '购买方式'")
    private String buyWay;

    /**
     * 门店编码
     */
    @ApiModelProperty("门店编码")
    @Column(name = "terminal_code", length = 32, columnDefinition = "varchar(32) COMMENT '门店编码'")
    private String terminalCode;
    /**
     * 门店名称
     */
    @ApiModelProperty("门店名称")
    @Column(name = "terminal_name", length = 255, columnDefinition = "varchar(255) COMMENT '门店名称'")
    private String terminalName;

    /**
     * 品牌编码
     */
    @ApiModelProperty("品牌编码")
    @Column(name = "product_brand_code", length = 32, columnDefinition = "varchar(32) COMMENT '品牌编码'")
    private String productBrandCode;

    /**
     * 品牌名称
     */
    @ApiModelProperty("品牌名称")
    @Column(name = "product_brand_name", length = 255, columnDefinition = "varchar(255) COMMENT '品牌名称'")
    private String productBrandName;

    /**
     * 品类编码
     */
    @ApiModelProperty("品类编码")
    @Column(name = "product_category_code", length = 32, columnDefinition = "varchar(32) COMMENT '品类编码'")
    private String productCategoryCode;

    /**
     * 品类名称
     */
    @ApiModelProperty("品类名称")
    @Column(name = "product_category_name", length = 255, columnDefinition = "varchar(255) COMMENT '品类名称'")
    private String productCategoryName;

    /**
     * 品项编码
     */
    @ApiModelProperty("品项编码")
    @Column(name = "product_item_code", length = 32, columnDefinition = "varchar(32) COMMENT '品项编码'")
    private String productItemCode;

    /**
     * 品项名称
     */
    @ApiModelProperty("品项名称")
    @Column(name = "product_item_name", length = 255, columnDefinition = "varchar(255) COMMENT '品项名称'")
    private String productItemName;

    /**
     * 产品编码
     */
    @ApiModelProperty("产品编码")
    @Column(name = "product_code", length = 32, columnDefinition = "varchar(32) COMMENT '产品编码'")
    private String productCode;

    /**
     * 产品名称
     */
    @ApiModelProperty("产品名称")
    @Column(name = "product_name", length = 255, columnDefinition = "varchar(255) COMMENT '产品名称'")
    private String productName;

    /**
     * 档期名称
     */
    @ApiModelProperty("档期名称")
    @Column(name = "schedule_name", columnDefinition = "varchar(64) COMMENT '档期名称'")
    private String scheduleName;

    /**
     * 单件申请费用
     */
    @ApiModelProperty("单件申请费用")
    @Column(name = "single_application_fee", length = 24, columnDefinition = "decimal(24,6) COMMENT '单件申请费用'")
    private BigDecimal singleApplicationFee;

    /**
     * 申请金额
     */
    @ApiModelProperty("申请金额")
    @Column(name = "apply_amount", precision = 24, scale = 6, columnDefinition = "decimal(24,6) COMMENT '申请金额(陈列方案用)'")
    private BigDecimal applyAmount;

    /**
     * 预估结案金额
     */
    @ApiModelProperty("预估结案金额")
    @Column(name = "prediction_accounts_amount", columnDefinition = "decimal(20,4) COMMENT '预估结案金额'")
    private BigDecimal predictionAccountsAmount;

    /**
     * 预估核销金额
     */
    @ApiModelProperty("预估核销金额")
    @Column(name = "prediction_audit_amount", columnDefinition = "decimal(20,4) COMMENT '预估核销金额'")
    private BigDecimal predictionAuditAmount;

    /**
     * 已核销金额
     */
    @ApiModelProperty("已核销金额")
    @Column(name = "already_audit_amount", columnDefinition = "decimal(20,4) COMMENT '已核销金额'")
    private BigDecimal alreadyAuditAmount;

    /**
     * 可核销金额
     */
    @ApiModelProperty("可核销金额")
    @Column(name = "can_audit_amount", columnDefinition = "decimal(20,4) COMMENT '可核销金额'")
    private BigDecimal canAuditAmount;

    /**
     * 是否完全结案
     */
    @ApiModelProperty("是否完全结案")
    @Column(name = "whole_audit", length = 10, columnDefinition = "VARCHAR(10) COMMENT '是否完全结案'")
    private String wholeAudit;

    /**
     * 匹配模板编码
     */
    @ApiModelProperty(name = "匹配模板编码", notes = "匹配模板编码")
    @Column(name = "match_template_code",  length = 64, columnDefinition = "VARCHAR(64) COMMENT '匹配模板编码'")
    private String matchTemplateCode;

    /**
     * 核销公式编码
     */
    @ApiModelProperty(name = "核销公式编码", notes = "核销公式编码")
    @Column(name = "audit_formula_code",  length = 64, columnDefinition = "VARCHAR(64) COMMENT '核销公式编码'")
    private String auditFormulaCode;

    /**
     * 核销公式名称
     */
    @ApiModelProperty(name = "核销公式名称", notes = "核销公式名称")
    @Column(name = "audit_formula_name",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '核销公式名称'")
    private String auditFormulaName;

    /**
     * 数据来源
     */
    @ApiModelProperty(name = "数据来源", notes = "数据来源")
    @Column(name = "data_source", length = 32, columnDefinition = "VARCHAR(32) COMMENT '数据来源'")
    private String dataSource;

    /**
     * 一级渠道编码
     */
    @ApiModelProperty(name = "一级渠道编码", notes = "")
    @Column(name = "first_channel_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '一级渠道编码 '")
    private String firstChannelCode;

    /**
     * 一级渠道名称
     */
    @ApiModelProperty(name = "一级渠道名称", notes = "")
    @Column(name = "first_channel_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '一级渠道名称 '")
    private String firstChannelName;

    /**
     * 二级渠道编码
     */
    @ApiModelProperty(name = "二级渠道编码", notes = "")
    @Column(name = "second_channel_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '二级渠道编码 '")
    private String secondChannelCode;

    /**
     * 二级渠道名称
     */
    @ApiModelProperty(name = "二级渠道名称", notes = "")
    @Column(name = "second_channel_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '二级渠道名称 '")
    private String secondChannelName;


    /**
     * 客户编码
     */
    @ApiModelProperty("客户编码")
    @Column(name = "customer_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '客户编码 '")
    private String customerCode;

    @ApiModelProperty("客户erp编码")
    @Column(name = "customer_erp_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '客户erp编码 '")
    private String customerErpCode;

    /**
     * 客户名称
     */
    @ApiModelProperty("客户名称")
    @Column(name = "customer_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '客户名称 '")
    private String customerName;

    /**
     * 回退预算状态：1未回退预算，2未完全回退预算，3已完全回退预算
     */
    @ApiModelProperty(name = "rollbackBudgetTag", notes = "是否已回退预算", value = "回退预算状态：1未回退预算，2未完全回退预算，3已完全回退预算")
    @Column(name = "rollback_budget_tag", length = 10, columnDefinition = "VARCHAR(10) COMMENT '回退预算状态：1未回退预算，2未完全回退预算，3已完全回退预算'")
    private String rollbackBudgetTag;


    /**
     * 是否关闭，   Y是N否
     */
    @ApiModelProperty(name = "isClose", notes = "是否关闭", value = "是否关闭，   Y是N否")
    @Column(name = "is_close", length = 10, columnDefinition = "VARCHAR(10) COMMENT '是否关闭'")
    private String isClose;

    /**
     * 省份编码
     * */
    @ApiModelProperty("省份编码")
    @Column(name = "province_code", length = 64,columnDefinition = "VARCHAR(64) COMMENT '省份编码'")
    private String provinceCode;

    /**
     * 省份
     * */
    @ApiModelProperty("省份")
    @Column(name = "province_name", length = 128,columnDefinition = "VARCHAR(128) COMMENT '省份'")
    private String provinceName;

    /**
     * 关闭时间
     */
    @ApiModelProperty("关闭时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "close_date",  columnDefinition = "datetime COMMENT '关闭时间'")
    private Date closeDate;

    /**
     * 零售商渠道
     */
    @ApiModelProperty("零售商渠道")
    @Column(name = "retailer_channel", length = 64, columnDefinition = "varchar(64) COMMENT 'retailer_channel'")
    private String retailerChannel;

}
