package com.biz.crm.tpm.business.audit.fee.local.entity.prediction;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Description:扣费预测-模板计算公式
 * @Author zy
 * @Date 2023/9/23
 */
@Data
@TableName("tpm_audit_fee_prediction_formula")
@Entity(name = "tpm_audit_fee_prediction_formula")
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "AuditFeePredictionFormula", description = "TPM-扣费预测管理")
@org.hibernate.annotations.Table(appliesTo = "tpm_audit_fee_prediction_formula", comment = "TPM-扣费预测管理")
@Table(name = "tpm_audit_fee_prediction_formula", indexes = {@Index(name = "tpm_audit_fee_cost_index1", columnList = "del_flag,tenant_code,detail_plan_item_code", unique = true)})
public class AuditFeePredictionFormula extends TenantFlagOpEntity {

    /**
     * 活动细案明细编码
     */
    @ApiModelProperty("活动细案明细编码")
    @TableField(value = "detail_plan_item_code")
    @Column(name = "detail_plan_item_code", length = 64, columnDefinition = "varchar(64) COMMENT '活动细案明细编码'")
    private String detailPlanItemCode;

    @ApiModelProperty("公式")
    @TableField(value = "formula_code")
    @Column(name = "formula_code", length = 255, columnDefinition = "varchar(255) COMMENT '公式'")
    private String formulaCode;

    @ApiModelProperty("公式（展示用）")
    @TableField(value = "formula_name")
    @Column(name = "formula_name", length = 255, columnDefinition = "varchar(255) COMMENT '公式（展示用）'")
    private String formulaName;

    @ApiModelProperty("公式json")
    @TableField(value = "formula_json")
    @Column(name = "formula_json", length = 255, columnDefinition = "varchar(255) COMMENT '公式json'")
    private String formulaJson;


}
