package com.biz.crm.tpm.business.audit.fee.local.entity.settlement.check;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Description:结算核对管理
 * @Author zy
 * @Date 2023/9/23
 */
@Data
@TableName("tpm_audit_fee_settlement_check")
@Entity(name = "tpm_audit_fee_settlement_check")
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "AuditFeeSettlementCheck", description = "TPM-扣费预测管理")
@org.hibernate.annotations.Table(appliesTo = "tpm_audit_fee_settlement_check", comment = "TPM-结算核对管理")
@Table(name = "tpm_audit_fee_settlement_check", indexes = {@Index(name = "tpm_audit_fee_settlement_check", columnList = "del_flag,tenant_code,code", unique = true)})
public class AuditFeeSettlementCheck extends TenantFlagOpEntity {


    /**
     * 数据编码
     */
    @ApiModelProperty(name = "数据编码", notes = "数据编码")
    @Column(name = "code",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '数据编码'")
    private String code;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(name = "业态[数据字典:mdm_business_format]", notes = "业态[数据字典:mdm_business_format]")
    @Column(name = "business_format_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '业态[数据字典:mdm_business_format] '")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(name = "业务单元[数据字典:mdm_business_unit]", notes = "业务单元[数据字典:mdm_business_unit]")
    @Column(name = "business_unit_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务单元[数据字典:mdm_business_unit] '")
    private String businessUnitCode;

    /**
     * 匹配模板编码
     */
    @ApiModelProperty(name = "匹配模板编码", notes = "匹配模板编码")
    @Column(name = "match_template_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '匹配模板编码'")
    private String matchTemplateCode;

    /**
     * 匹配模板名称
     */
    @ApiModelProperty(name = "匹配模板名称", notes = "匹配模板名称")
    @Column(name = "match_template_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '匹配模板名称'")
    private String matchTemplateName;

    /**
     * 匹配模板类型
     */
    @ApiModelProperty(name = "匹配模板类型", notes = "匹配模板类型")
    @Column(name = "match_template_type", length = 64, columnDefinition = "VARCHAR(64) COMMENT '匹配模板类型'")
    private String matchTemplateType;

    @ApiModelProperty(name = "对账年月", notes = "对账年月")
    @Column(name = "order_year_month_str",  length = 7, columnDefinition = "VARCHAR(7) COMMENT '对账年月(yyyy-MM)'")
    private String orderYearMonthStr;

    @ApiModelProperty(name = "对账日期", notes = "对账日期")
    @Column(name = "order_date",  columnDefinition = "VARCHAR(32) COMMENT '对账年月(yyyy-MM-dd)'")
    private String orderDate;

    @ApiModelProperty("实际扣费年月")
    @DateTimeFormat(pattern = "yyyy-MM")
    @Column(name = "actual_year_month",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '实际扣费年月'")
    private String actualYearMonth;

    /**
     * 零售商编码
     */
    @ApiModelProperty("零售商编码")
    @Column(name = "system_code", length = 32, columnDefinition = "varchar(32) COMMENT '零售商编码'")
    private String systemCode;

    /**
     * 零售商名称
     */
    @ApiModelProperty("零售商名称")
    @Column(name = "system_name", length = 200, columnDefinition = "varchar(200) COMMENT '零售商名称'")
    private String systemName;

    /**
     * 客户编码
     */
    @ApiModelProperty("客户编码")
    @Column(name = "customer_code", length = 32, columnDefinition = "varchar(32) COMMENT '客户编码'")
    private String customerCode;

    /**
     * 客户名称
     */
    @ApiModelProperty("客户名称")
    @Column(name = "customer_name", length = 200, columnDefinition = "varchar(200) COMMENT '客户名称'")
    private String customerName;

    /**
     * 区域
     */
    @ApiModelProperty("区域")
    @Column(name = "region", length = 32, columnDefinition = "varchar(32) COMMENT '区域'")
    private String region;

    /**
     * 结算单
     */
    @ApiModelProperty("结算单")
    @Column(name = "settlement_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '结算单'")
    private BigDecimal settlementAmount;

    /**
     * 费用单
     */
    @ApiModelProperty("费用单")
    @Column(name = "fee_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '费用单'")
    private BigDecimal feeAmount;

    /**
     * 细案
     */
    @ApiModelProperty("细案")
    @Column(name = "detail_plan_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '细案'")
    private BigDecimal detailPlanAmount;

    /**
     * 结算单-费单差异（元）
     */
    @ApiModelProperty("结算单-费单差异（元）")
    @Column(name = "settlement_fee_diff", length = 24, columnDefinition = "decimal(24,6) COMMENT '结算单-费单差异（元）'")
    private BigDecimal settlementFeeDiff;

    /**
     * 结算单-细案差异（元）
     */
    @ApiModelProperty("结算单-细案差异（元）")
    @Column(name = "settlement_detail_plan_diff", length = 24, columnDefinition = "decimal(24,6) COMMENT '结算单-细案差异（元）'")
    private BigDecimal settlementDetailPlanDiff;

    /**
     * 键
     */
    @ApiModelProperty(name = "md5UniqueKey", notes = "键")
    @Column(name = "md5_unique_key", length = 128, columnDefinition = "VARCHAR(128) COMMENT '键'")
    private String md5UniqueKey;

    /**
     * 匹配状态
     */
    @ApiModelProperty(name = "matchStatus", notes = "匹配状态")
    @Column(name = "match_status", length = 32, columnDefinition = "VARCHAR(32) COMMENT '匹配状态'")
    private String matchStatus;

    /**
     * 是否匹配上活动
     */
    @ApiModelProperty(name = "是否匹配上活动", notes = "是否匹配上活动")
    @Column(name = "match_activity", length = 1, columnDefinition = "tinyint(1) COMMENT '是否匹配上活动'")
    private Boolean matchActivity;

    /**
     * 匹配结果
     */
    @ApiModelProperty(name = "匹配结果", notes = "匹配结果")
    @Column(name = "match_result",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '匹配结果'")
    private String matchResult;

    /**
     * 是否分摊
     */
    @ApiModelProperty(name = "是否分摊", notes = "是否分摊")
    @Column(name = "is_share",  length = 8, columnDefinition = "VARCHAR(8) COMMENT '是否分摊(Y,N)'")
    private String isShare;

    /**
     * 差异确认金额
     */
    @ApiModelProperty("差异确认金额")
    @Column(name = "diff_confirm_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '差异确认金额'")
    private BigDecimal diffConfirmAmount;

    /**
     * 差异类型
     */
    @ApiModelProperty(name = "差异类型", notes = "差异类型")
    @Column(name = "diff_type", length = 32, columnDefinition = "VARCHAR(32) COMMENT '差异类型'")
    private String diffType;

    /**
     * 差异使用
     */
    @ApiModelProperty(name = "差异使用", notes = "差异使用")
    @Column(name = "diff_use", length = 32, columnDefinition = "VARCHAR(32) COMMENT '差异使用'")
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String diffUse;

    /**
     * 是否确认
     */
    @ApiModelProperty(name = "是否确认", notes = "是否确认")
    @Column(name = "is_confirm",  length = 8, columnDefinition = "VARCHAR(8) COMMENT '是否确认(Y,N)'")
    private String isConfirm;

    /**
     * 确认人
     */
    @ApiModelProperty(name = "confirmUserName", notes = "确认人名称", value = "确认人名称")
    @Column(name = "confirm_user_name",  length = 64, columnDefinition = "VARCHAR(64) COMMENT '确认人名称'")
    private String confirmUserName;

    /**
     * 确认人账号
     */
    @ApiModelProperty(name = "confirmUserAccount", notes = "确认人账号", value = "确认人账号")
    @Column(name = "confirm_user_account",  length = 64, columnDefinition = "VARCHAR(64) COMMENT '确认人账号'")
    private String confirmUserAccount;

    /**
     * 确认时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @Column(name = "confirm_time",   columnDefinition = "datetime COMMENT '确认时间'")
    @ApiModelProperty(name = "confirmTime",notes = "确认时间", value= "确认时间")
    private Date confirmTime;

    /**
     * 差异状态
     */
    @ApiModelProperty(name = "差异状态", notes = "差异状态")
    @Column(name = "diff_status", length = 32, columnDefinition = "VARCHAR(32) COMMENT '差异状态'")
    private String diffStatus;

    @ApiModelProperty("销售组织编码")
    @Column(name = "sales_org_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售组织编码'")
    private String salesOrgCode;

    @ApiModelProperty("销售组织名称")
    @Column(name = "sales_org_name", length = 128, columnDefinition = "VARCHAR(32) COMMENT '销售组织名称'")
    private String salesOrgName;

    @ApiModelProperty("数据来源")
    @Column(name = "data_source", length = 32, columnDefinition = "VARCHAR(32) COMMENT '数据来源'")
    private String dataSource;

    @ApiModelProperty("查询年月开始时间")
    @Column(name = "query_start_date", length = 32, columnDefinition = "VARCHAR(32) COMMENT '查询年月开始时间'")
    private String queryStartDate;

    @ApiModelProperty("查询年月结束时间")
    @Column(name = "query_end_date", length = 32, columnDefinition = "VARCHAR(32) COMMENT '查询年月结束时间'")
    private String queryEndDate;

    @ApiModelProperty(name = "activityTypeCode", value = "活动分类编码", notes = "活动分类编码")
    @Column(name = "activity_type_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动分类编码'")
    private String activityTypeCode;

    @ApiModelProperty(name = "activityTypeName", value = "活动分类名称", notes = "活动分类名称")
    @Column(name = "activity_type_name", length = 255, columnDefinition = "VARCHAR(255) COMMENT '活动分类名称'")
    private String activityTypeName;
}
