package com.biz.crm.tpm.business.audit.fee.local.entity.settlement.check;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Description:结算核对管理-细案
 * @Author zy
 * @Date 2023/9/23
 */
@Data
@TableName("tpm_audit_fee_settlement_check_detail_plan")
@Entity(name = "tpm_audit_fee_settlement_check_detail_plan")
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "AuditFeeSettlementCheckDetailPlan", description = "TPM-结算核对管理-细案")
@org.hibernate.annotations.Table(appliesTo = "tpm_audit_fee_settlement_check_detail_plan", comment = "TPM-结算核对管理-细案")
@Table(name = "tpm_audit_fee_settlement_check_detail_plan",
        indexes = {
        @Index(name = "tpm_audit_fee_settlement_check_detail_plan_index", columnList = "del_flag,tenant_code"),
        @Index(name = "tpm_audit_fee_settlement_check_detail_plan_index2", columnList = "del_flag,tenant_code,code"),
        @Index(name = "tpm_audit_fee_settlement_check_detail_plan_index3", columnList = "del_flag,tenant_code,code,detail_plan_item_code")
})
public class AuditFeeSettlementCheckDetailPlan extends TenantFlagOpEntity {

    /**
     * 数据编码
     */
    @ApiModelProperty(name = "数据编码", notes = "数据编码")
    @Column(name = "code",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '数据编码'")
    private String code;

    /**
     * 活动细案明细编码
     */
    @ApiModelProperty("活动细案明细编码")
    @TableField(value = "detail_plan_item_code")
    @Column(name = "detail_plan_item_code", length = 64, columnDefinition = "varchar(64) COMMENT '活动细案明细编码'")
    private String detailPlanItemCode;

    /**
     * 活动细案编码
     */
    @ApiModelProperty("活动细案编码")
    @Column(name = "detail_plan_code", length = 32, columnDefinition = "varchar(32) COMMENT '活动细案编码'")
    private String detailPlanCode;

    /**
     * 活动细案名称
     */
    @ApiModelProperty("活动细案名称")
    @Column(name = "detail_plan_name",length = 255, columnDefinition = "varchar(255) COMMENT '活动细案名称'")
    private String detailPlanName;

    /**
     * 活动开始时间
     */
    @ApiModelProperty("活动开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "activity_begin_date", columnDefinition = "datetime COMMENT '活动开始时间'")
    private Date activityBeginDate;

    /**
     * 活动结束时间
     */
    @ApiModelProperty("活动结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "activity_end_date",  columnDefinition = "datetime COMMENT '活动结束时间'")
    private Date activityEndDate;

    /**
     * 活动年月（取活动开始时间年月）
     */
    @ApiModelProperty("活动年月")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    @Column(name = "activity_year_month",  columnDefinition = "datetime COMMENT '活动年月'")
    private Date activityYearMonth;

    /**
     * 零售商编码
     */
    @ApiModelProperty("零售商编码")
    @Column(name = "system_code", length = 32, columnDefinition = "varchar(32) COMMENT '零售商编码'")
    private String systemCode;

    /**
     * 零售商名称
     */
    @ApiModelProperty("零售商名称")
    @Column(name = "system_name", length = 200, columnDefinition = "varchar(200) COMMENT '零售商名称'")
    private String systemName;

    /**
     * 区域
     */
    @ApiModelProperty("区域")
    @Column(name = "region", length = 32, columnDefinition = "varchar(32) COMMENT '区域'")
    private String region;

    /**
     * 省编码
     */
    @ApiModelProperty("省编码")
    @Column(name = "province_code",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '省编码'")
    private String provinceCode;

    /**
     * 省名称(门店管理-省)
     */
    @ApiModelProperty("省名称")
    @Column(name = "province_name",  length = 64, columnDefinition = "VARCHAR(64) COMMENT '省名称'")
    private String provinceName;

    /**
     * 活动类型编码
     */
    @ApiModelProperty("活动类型编码")
    @Column(name = "activity_type_code", length = 255, columnDefinition = "varchar(255) COMMENT '活动类型编码'")
    private String activityTypeCode;

    /**
     * 活动类型名称
     */
    @ApiModelProperty("活动类型名称")
    @Column(name = "activity_type_name", length = 255, columnDefinition = "varchar(255) COMMENT '活动类型名称'")
    private String activityTypeName;

    /**
     * 活动形式编码
     */
    @ApiModelProperty("活动形式编码")
    @Column(name = "activity_form_code", length = 255, columnDefinition = "varchar(255) COMMENT '活动形式编码'")
    private String activityFormCode;

    /**
     * 活动形式名称
     */
    @ApiModelProperty("活动形式名称")
    @Column(name = "activity_form_name", length = 255, columnDefinition = "varchar(255) COMMENT '活动形式名称'")
    private String activityFormName;

    /**
     * 结案形式
     */
    @ApiModelProperty("结案形式")
    @Column(name = "audit_form", length = 32, columnDefinition = "varchar(32) COMMENT '结案形式'")
    private String auditForm;

    /**
     * 购买方式
     */
    @ApiModelProperty("购买方式")
    @Column(name = "buy_way", length = 32, columnDefinition = "varchar(32) COMMENT '购买方式'")
    private String buyWay;

    @ApiModelProperty("客户编码")
    @Column(name = "customer_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '客户编码 '")
    private String customerCode;

    @ApiModelProperty("客户名称")
    @Column(name = "customer_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '客户名称 '")
    private String customerName;

    /**
     * 门店编码
     */
    @ApiModelProperty("门店编码")
    @Column(name = "terminal_code", length = 32, columnDefinition = "varchar(32) COMMENT '门店编码'")
    private String terminalCode;
    /**
     * 门店名称
     */
    @ApiModelProperty("门店名称")
    @Column(name = "terminal_name", length = 255, columnDefinition = "varchar(255) COMMENT '门店名称'")
    private String terminalName;

    /**
     * 产品编码
     */
    @ApiModelProperty("产品编码")
    @Column(name = "product_code", length = 32, columnDefinition = "varchar(32) COMMENT '产品编码'")
    private String productCode;

    /**
     * 产品名称
     */
    @ApiModelProperty("产品名称")
    @Column(name = "product_name", length = 255, columnDefinition = "varchar(255) COMMENT '产品名称'")
    private String productName;

    /**
     * 档期名称
     */
    @ApiModelProperty("档期名称")
    @Column(name = "schedule_name", columnDefinition = "varchar(64) COMMENT '档期名称'")
    private String scheduleName;

    @ApiModelProperty("所属销售机构编码")
    @Column(name = "sales_institution_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '所属销售机构编码'")
    private String salesInstitutionCode;

    @ApiModelProperty("所属销售机构")
    @Column(name = "sales_institution_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '所属销售机构'")
    private String salesInstitutionName;

    @ApiModelProperty("单件申请费用")
    @Column(name = "single_application_fee", length = 24, columnDefinition = "decimal(24,6) COMMENT '单件申请费用'")
    private BigDecimal singleApplicationFee;

    /**
     * 申请金额
     */
    @ApiModelProperty("申请金额")
    @Column(name = "apply_amount", precision = 24, scale = 6, columnDefinition = "decimal(24,6) COMMENT '申请金额(陈列方案用)'")
    private BigDecimal applyAmount;

    /**
     * 预估核销金额
     */
    @ApiModelProperty("预估核销金额")
    @Column(name = "prediction_audit_amount", columnDefinition = "decimal(20,4) COMMENT '预估核销金额'")
    private BigDecimal predictionAuditAmount;

    /**
     * 已核销金额
     */
    @ApiModelProperty("已核销金额")
    @Column(name = "already_audit_amount", columnDefinition = "decimal(20,4) COMMENT '已核销金额'")
    private BigDecimal alreadyAuditAmount;

    /**
     * 可核销金额
     */
    @ApiModelProperty("可核销金额")
    @Column(name = "can_audit_amount", columnDefinition = "decimal(20,4) COMMENT '可核销金额'")
    private BigDecimal canAuditAmount;

    @ApiModelProperty("活动形式说明")
    @Column(name = "activity_form_desc", columnDefinition = "text COMMENT '活动形式说明'")
    private String activityFormDesc;

    /**
     * 存储在分摊表 {@link com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheckDetailPlanShare}
     */
    @ApiModelProperty("扣费匹配分摊金额，一个细案可分摊多个核对数据，故此属性根据核对编号存在不同的值")
    @TableField(exist = false)
    private BigDecimal auditFeeCheckShareAmount;
    @ApiModelProperty("待补录金额（元）")
    @TableField(exist = false)
    private BigDecimal toBeSupplementedAmount;
    @ApiModelProperty("本次核销金额（元）")
    @TableField(exist = false)
    private BigDecimal thisAuditAmount;

}
