package com.biz.crm.tpm.business.audit.fee.local.entity.settlement.check;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author liyang
 * @date 2023/10/28
 */
@Data
@TableName("tpm_audit_fee_settlement_check_detail_plan_share")
@Entity(name = "tpm_audit_fee_settlement_check_detail_plan_share")
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "AuditFeeSettlementCheckDetailPlanShare", description = "TPM-结算核对管理-细案分摊")
@org.hibernate.annotations.Table(appliesTo = "tpm_audit_fee_settlement_check_detail_plan_share", comment = "TPM-结算核对管理-细案分摊")
@Table(name = "tpm_audit_fee_settlement_check_detail_plan_share")
public class AuditFeeSettlementCheckDetailPlanShare extends UuidEntity {

  @ApiModelProperty(name = "数据编码", notes = "数据编码")
  @Column(name = "code",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '数据编码'")
  private String code;

  @ApiModelProperty("活动细案明细编码")
  @Column(name = "detail_plan_item_code", length = 64, columnDefinition = "varchar(64) COMMENT '活动细案明细编码'")
  private String detailPlanItemCode;

  @ApiModelProperty("扣费匹配分摊金额，一个细案可分摊多个核对数据，故此属性根据核对编号存在不同的值")
  @Column(name = "audit_fee_check_share_amount", columnDefinition = "decimal(20,6) COMMENT '扣费匹配分摊金额'")
  private BigDecimal auditFeeCheckShareAmount;

  @ApiModelProperty("待补录金额（元）")
  @Column(name = "to_be_supplemented_amount", columnDefinition = "decimal(24,6) COMMENT '待补录金额（元）'")
  private BigDecimal toBeSupplementedAmount;

  @ApiModelProperty("本次核销金额（元）")
  @Column(name = "this_audit_amount", columnDefinition = "decimal(24,6) COMMENT '本次核销金额（元）'")
  private BigDecimal thisAuditAmount;
}
