package com.biz.crm.tpm.business.audit.fee.local.entity.settlement.check;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @Description:结算核对管理-差异信息
 * @Author zy
 * @Date 2023/9/23
 */
@Data
@TableName("tpm_audit_fee_settlement_check_diff")
@Entity(name = "tpm_audit_fee_settlement_check_diff")
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "AuditFeeSettlementCheckDiff", description = "TPM-扣费预测管理")
@org.hibernate.annotations.Table(appliesTo = "tpm_audit_fee_settlement_check_diff", comment = "TPM-结算核对管理")
@Table(name = "tpm_audit_fee_settlement_check_diff", indexes = {
        @Index(name = "tpm_audit_fee_settlement_check_diff_index1", columnList = "del_flag,tenant_code,code,fee_diff_ledger_code")
})
public class AuditFeeSettlementCheckDiff extends TenantFlagOpEntity {

    @ApiModelProperty(name = "auditFeeCheckCode", notes = "核销费用核对表扣费匹配单号来源")
    @Column(name = "audit_fee_check_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '核销费用核对表扣费匹配单号来源'")
    private String auditFeeCheckCode;

    @ApiModelProperty(name = "数据编码", notes = "数据编码")
    @Column(name = "code",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '数据编码'")
    private String code;

    @ApiModelProperty(name = "feeDiffLedgerCode", notes = "差异费用编码")
    @Column(name = "fee_diff_ledger_code", length = 128, columnDefinition = "VARCHAR(128) COMMENT '差异费用编码'")
    private String feeDiffLedgerCode;

    @ApiModelProperty(name = "status", notes = "状态[字典：audit_fee_diff_status]")
    @Column(name = "status", length = 32, columnDefinition = "VARCHAR(32) COMMENT '状态[字典：audit_fee_diff_status]'")
    private String status;

    @ApiModelProperty(name = "year", notes = "年份")
    @Column(name = "year", length = 32, columnDefinition = "VARCHAR(6) COMMENT '年份'")
    private String year;

    @ApiModelProperty(name = "月份", notes = "月份")
    @Column(name = "month", length = 32, columnDefinition = "VARCHAR(4) COMMENT '月份'")
    private String month;

    @ApiModelProperty("费用所属年月")
    @Column(name = "fee_year_month", length = 20, columnDefinition = "VARCHAR(8) COMMENT '费用所属年月 '")
    private String feeYearMonth;

    @ApiModelProperty(name = "业态[数据字典:mdm_business_format]", notes = "业态[数据字典:mdm_business_format]")
    @Column(name = "business_format_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '业态[数据字典:mdm_business_format] '")
    private String businessFormatCode;

    @ApiModelProperty(name = "业务单元[数据字典:mdm_business_unit]", notes = "业务单元[数据字典:mdm_business_unit]")
    @Column(name = "business_unit_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务单元[数据字典:mdm_business_unit] '")
    private String businessUnitCode;

    @ApiModelProperty(name = "salesOrgCode", notes = "销售组织编码")
    @Column(name = "sales_org_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售组织编码 '")
    private String salesOrgCode;

    @ApiModelProperty(name = "salesOrgName", notes = "销售组织名称")
    @Column(name = "sales_org_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '销售组织名称 '")
    private String salesOrgName;

    @ApiModelProperty(name = "businessAreaCode", notes = "区域")
    @Column(name = "business_area_code", length = 32, columnDefinition = "VARCHAR(10) COMMENT '区域'")
    private String businessAreaCode;

    @ApiModelProperty(name = "businessAreaName", value = "区域名称")
    @Column(name = "business_area_name", length = 255, columnDefinition = "VARCHAR(10) COMMENT '区域名称'")
    private String businessAreaName;

    @ApiModelProperty(name = "零售商编码")
    @Column(name = "retailer_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '零售商编码'")
    private String retailerCode;

    @ApiModelProperty(name = "零售商名称")
    @Column(name = "retailer_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '零售商名称'")
    private String retailerName;

    @ApiModelProperty("售达方编码")
    @Column(name = "sold_to_party_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '售达方编码'")
    private String soldToPartyCode;

    @ApiModelProperty("售达方名称")
    @Column(name = "sold_to_party_name", length = 255, columnDefinition = "VARCHAR(255) COMMENT '售达方名称'")
    private String soldToPartyName;

    @ApiModelProperty("送达方编码")
    @Column(name = "delivery_party_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '售达方编码'")
    private String deliveryPartyCode;

    @ApiModelProperty("送达方名称")
    @Column(name = "delivery_party_name", length = 255, columnDefinition = "VARCHAR(255) COMMENT '售达方名称'")
    private String deliveryPartyName;

    @ApiModelProperty(name = "activitiesType", notes = "活动分类")
    @Column(name = "activities_type", length = 64, columnDefinition = "VARCHAR(64) COMMENT '活动分类 '")
    private String activitiesType;

    @ApiModelProperty(name = "activitiesTypeName", notes = "活动分类名称")
    @Column(name = "activities_type_name", length = 255, columnDefinition = "VARCHAR(255) COMMENT '活动分类 '")
    private String activitiesTypeName;

    @ApiModelProperty(name = "activityFormCode", notes = "活动形式编码")
    @Column(name = "activity_form_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '活动形式编码 '")
    private String activityFormCode;

    @ApiModelProperty(name = "activityFormName", notes = "活动形式名称")
    @Column(name = "activity_form_name", length = 255, columnDefinition = "VARCHAR(255) COMMENT '活动形式名称 '")
    private String activityFormName;

    @ApiModelProperty(name = "beRecoveredAmount", notes = "待追回金额", value = "待追回金额")
    @Column(name = "be_recovered_amount", columnDefinition = "Decimal(24,6) COMMENT '待追回金额 '")
    private BigDecimal beRecoveredAmount;

    @ApiModelProperty(name = "followUpPerson", notes = "跟进人", value = "跟进人")
    @Column(name = "follow_up_person", length = 64, columnDefinition = "VARCHAR(64) COMMENT '跟进人 '")
    private String followUpPerson;

    /**
     * 抵扣金额
     * 存储在分摊表 {@link com.biz.crm.tpm.business.audit.fee.local.entity.settlement.check.AuditFeeSettlementCheckDiffShare}
     */
    @ApiModelProperty(name = "deductAmount", notes = "抵扣金额", value = "抵扣金额")
    @TableField(exist = false)
    private BigDecimal deductAmount;

}
