package com.biz.crm.tpm.business.audit.fee.local.entity.settlement.check;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author liyang
 * @date 2023/10/30
 */
@Data
@TableName("tpm_audit_fee_settlement_check_diff_share")
@Entity(name = "tpm_audit_fee_settlement_check_diff_share")
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "AuditFeeSettlementCheckDiffShare", description = "TPM-扣费预测管理扣减")
@org.hibernate.annotations.Table(appliesTo = "tpm_audit_fee_settlement_check_diff_share", comment = "TPM-扣费预测管理扣减")
@Table(name = "tpm_audit_fee_settlement_check_diff_share")
public class AuditFeeSettlementCheckDiffShare extends UuidEntity {

  @ApiModelProperty(name = "数据编码", notes = "数据编码")
  @Column(name = "code",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '数据编码'")
  private String code;

  @ApiModelProperty(name = "feeDiffLedgerCode", notes = "差异费用编码")
  @Column(name = "fee_diff_ledger_code", length = 128, columnDefinition = "VARCHAR(128) COMMENT '差异费用编码'")
  private String feeDiffLedgerCode;

  @ApiModelProperty(name = "deductAmount", notes = "抵扣金额", value = "抵扣金额")
  @Column(name = "deduct_amount", columnDefinition = "Decimal(24,6) COMMENT '抵扣金额 '")
  private BigDecimal deductAmount;
}
