package com.biz.crm.tpm.business.audit.fee.local.entity.settlement.check;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * @Description:结算核对管理-费用单
 * @Author zy
 * @Date 2023/9/23
 */
@Data
@TableName("tpm_audit_fee_settlement_check_fee")
@Entity(name = "tpm_audit_fee_settlement_check_fee")
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "AuditFeeSettlementCheckFee", description = "TPM-扣费预测管理")
@org.hibernate.annotations.Table(appliesTo = "tpm_audit_fee_settlement_check_fee", comment = "TPM-结算核对管理")
@Table(name = "tpm_audit_fee_settlement_check_fee",
        indexes = {
        @Index(name = "tpm_audit_fee_settlement_check_fee_index", columnList = "del_flag,tenant_code"),
        @Index(name = "tpm_audit_fee_settlement_check_fee_index2", columnList = "del_flag,tenant_code,code"),
        @Index(name = "tpm_audit_fee_settlement_check_fee_index3", columnList = "del_flag,tenant_code,code,fee_detail_code")
})
public class AuditFeeSettlementCheckFee extends TenantFlagOpEntity {

    /**
     * 数据编码
     */
    @ApiModelProperty(name = "数据编码", notes = "数据编码")
    @Column(name = "code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '数据编码'")
    private String code;
    
    /**
     * 扣费明细编码
     */
    @ApiModelProperty(name = "扣费明细编码", notes = "扣费明细编码")
    @Column(name = "fee_detail_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '扣费明细编码'")
    private String feeDetailCode;


    @ApiModelProperty("业务区域")
    @Column(name = "business_area", length = 128, columnDefinition = "VARCHAR(128) COMMENT '业务区域'")
    private String businessArea;

    /**
     * 零售商编码（kms系统编码）
     */
    @ApiModelProperty("零售商编码（kms系统编码）")
    @Column(name = "direct_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '零售商编码（kms系统编码）'")
    private String directCode;

    /**
     * 零售商名称（kms系统名称）
     */
    @ApiModelProperty("零售商名称（kms系统名称）")
    @Column(name = "supermarket_name", length = 32, columnDefinition = "VARCHAR(32) COMMENT '零售商名称（kms系统名称码）'")
    private String supermarketName;


    /**
     * 省编码(门店管理-省)
     */
    @ApiModelProperty("省编码(门店管理-省)")
    @Column(name = "province_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '省编码(门店管理-省)'")
    private String provinceCode;

    /**
     * 省名称(门店管理-省)
     */
    @ApiModelProperty("省名称(门店管理-省)")
    @Column(name = "province_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '省名称(门店管理-省)'")
    private String provinceName;

    /**
     * 送达方编码
     */
    @ApiModelProperty("送达方编码")
    @Column(name = "delivery_party_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '送达方编码'")
    private String deliveryPartyCode;

    /**
     * 送达方名称
     */
    @ApiModelProperty("送达方名称")
    @Column(name = "delivery_party_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '送达方名称'")
    private String deliveryPartyName;

    /**
     * 产品编码
     */
    @ApiModelProperty("产品编码")
    @Column(name = "product_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '产品编码'")
    private String productCode;

    /**
     * 产品名称
     */
    @ApiModelProperty("产品名称")
    @Column(name = "product_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '产品名称'")
    private String productName;

    /**
     * 档期名称
     */
    @ApiModelProperty("档期名称")
    @Column(name = "slot_date_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '档期名称'")
    private String slotDateName;

    @ApiModelProperty("结算日期")
    @Column(name = "order_date", length = 32, columnDefinition = "VARCHAR(32) COMMENT '结算日期'")
    private String orderDate;

    @ApiModelProperty("结算年月")
    @Column(name = "order_year_month", length = 32, columnDefinition = "VARCHAR(32) COMMENT '结算年月'")
    private String orderYearMonth;

    @ApiModelProperty("实际扣费年月")
    @DateTimeFormat(pattern = "yyyy-MM")
    @Column(name = "actual_year_month",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '实际扣费年月'")
    private String actualYearMonth;

    /**
     * 扣费明细项编码
     */
    @ApiModelProperty("扣费明细项编码")
    @Column(name = "deduction_code",  length = 64, columnDefinition = "VARCHAR(64) COMMENT '扣费明细项编码'")
    private String deductionCode;

    /**
     * 扣费项名称
     */
    @ApiModelProperty("扣费明细项名称")
    @Column(name = "deduction_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '扣费明细项名称'")
    private String deductionName;

    /**
     * 结案形式
     */
    @ApiModelProperty("结案形式")
    @Column(name = "audit_way", length = 32, columnDefinition = "VARCHAR(32) COMMENT '结案形式'")
    private String auditWay;

    /**
     * 兑付方式
     */
    @ApiModelProperty("兑付方式")
    @Column(name = "cashing_type", length = 32, columnDefinition = "VARCHAR(32) COMMENT '兑付方式'")
    private String cashingType;

    /**
     * 结算金额（含税）
     */
    @ApiModelProperty("扣费金额（含税）")
    @Column(name = "amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '扣费金额（含税）'")
    private BigDecimal amount;

    /**
     * 数据来源
     */
    @ApiModelProperty(name = "数据来源", notes = "数据来源")
    @Column(name = "data_source", length = 32, columnDefinition = "VARCHAR(32) COMMENT '数据来源'")
    private String dataSource;


}
